
package org.dmg.pmml.time_series;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "")
@XmlRootElement(name = "Level", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
public class Level
    extends PMMLObject
{

    @XmlAttribute(name = "alpha")
    private Double alpha;
    @XmlAttribute(name = "quadraticSmoothedValue")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_4_1))
    private Double quadraticSmoothedValue;
    @XmlAttribute(name = "cubicSmoothedValue")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_4_1))
    private Double cubicSmoothedValue;
    @XmlAttribute(name = "smoothedValue")
    private Double smoothedValue;
    private final static long serialVersionUID = 67305483L;

    public Double getAlpha() {
        return alpha;
    }

    public Level setAlpha(
        @Property("alpha")
        Double alpha) {
        this.alpha = alpha;
        return this;
    }

    public Double getQuadraticSmoothedValue() {
        return quadraticSmoothedValue;
    }

    public Level setQuadraticSmoothedValue(
        @Property("quadraticSmoothedValue")
        Double quadraticSmoothedValue) {
        this.quadraticSmoothedValue = quadraticSmoothedValue;
        return this;
    }

    public Double getCubicSmoothedValue() {
        return cubicSmoothedValue;
    }

    public Level setCubicSmoothedValue(
        @Property("cubicSmoothedValue")
        Double cubicSmoothedValue) {
        this.cubicSmoothedValue = cubicSmoothedValue;
        return this;
    }

    public Double getSmoothedValue() {
        return smoothedValue;
    }

    public Level setSmoothedValue(
        @Property("smoothedValue")
        Double smoothedValue) {
        this.smoothedValue = smoothedValue;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
