
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.Removed;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "timeAnchor",
    "timeExceptions",
    "timeValues"
})
@XmlRootElement(name = "TimeSeries", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
public class TimeSeries
    extends org.dmg.pmml.PMMLObject
{

    @XmlAttribute(name = "usage")
    private TimeSeries.Usage usage;
    @XmlAttribute(name = "startTime")
    private Double startTime;
    @XmlAttribute(name = "endTime")
    private Double endTime;
    @XmlAttribute(name = "interpolationMethod")
    private TimeSeries.InterpolationMethod interpolationMethod;
    @XmlElement(name = "TimeAnchor", namespace = "http://www.dmg.org/PMML-4_3")
    private TimeAnchor timeAnchor;
    @XmlElement(name = "TimeException", namespace = "http://www.dmg.org/PMML-4_3")
    @Removed((org.dmg.pmml.Version.PMML_4_1))
    private List<TimeException> timeExceptions;
    @XmlElement(name = "TimeValue", namespace = "http://www.dmg.org/PMML-4_3")
    private List<TimeValue> timeValues;
    private final static long serialVersionUID = 67305483L;

    public TimeSeries.Usage getUsage() {
        if (usage == null) {
            return TimeSeries.Usage.ORIGINAL;
        } else {
            return usage;
        }
    }

    public TimeSeries setUsage(
        @Property("usage")
        TimeSeries.Usage usage) {
        this.usage = usage;
        return this;
    }

    public Double getStartTime() {
        return startTime;
    }

    public TimeSeries setStartTime(
        @Property("startTime")
        Double startTime) {
        this.startTime = startTime;
        return this;
    }

    public Double getEndTime() {
        return endTime;
    }

    public TimeSeries setEndTime(
        @Property("endTime")
        Double endTime) {
        this.endTime = endTime;
        return this;
    }

    public TimeSeries.InterpolationMethod getInterpolationMethod() {
        if (interpolationMethod == null) {
            return TimeSeries.InterpolationMethod.NONE;
        } else {
            return interpolationMethod;
        }
    }

    public TimeSeries setInterpolationMethod(
        @Property("interpolationMethod")
        TimeSeries.InterpolationMethod interpolationMethod) {
        this.interpolationMethod = interpolationMethod;
        return this;
    }

    public TimeAnchor getTimeAnchor() {
        return timeAnchor;
    }

    public TimeSeries setTimeAnchor(
        @Property("timeAnchor")
        TimeAnchor timeAnchor) {
        this.timeAnchor = timeAnchor;
        return this;
    }

    public List<TimeException> getTimeExceptions() {
        if (timeExceptions == null) {
            timeExceptions = new ArrayList<TimeException>();
        }
        return this.timeExceptions;
    }

    public List<TimeValue> getTimeValues() {
        if (timeValues == null) {
            timeValues = new ArrayList<TimeValue>();
        }
        return this.timeValues;
    }

    public boolean hasTimeExceptions() {
        return ((this.timeExceptions!= null)&&(this.timeExceptions.size()> 0));
    }

    public TimeSeries addTimeExceptions(TimeException... timeExceptions) {
        getTimeExceptions().addAll(Arrays.asList(timeExceptions));
        return this;
    }

    public boolean hasTimeValues() {
        return ((this.timeValues!= null)&&(this.timeValues.size()> 0));
    }

    public TimeSeries addTimeValues(TimeValue... timeValues) {
        getTimeValues().addAll(Arrays.asList(timeValues));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTimeAnchor());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTimeExceptions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTimeExceptions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTimeValues()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTimeValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum InterpolationMethod {

        @XmlEnumValue("none")
        NONE("none"),
        @XmlEnumValue("linear")
        LINEAR("linear"),
        @XmlEnumValue("exponentialSpline")
        EXPONENTIAL_SPLINE("exponentialSpline"),
        @XmlEnumValue("cubicSpline")
        CUBIC_SPLINE("cubicSpline");
        private final String value;

        InterpolationMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TimeSeries.InterpolationMethod fromValue(String v) {
            for (TimeSeries.InterpolationMethod c: TimeSeries.InterpolationMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum Usage {

        @XmlEnumValue("original")
        ORIGINAL("original"),
        @XmlEnumValue("logical")
        LOGICAL("logical"),
        @XmlEnumValue("prediction")
        PREDICTION("prediction");
        private final String value;

        Usage(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TimeSeries.Usage fromValue(String v) {
            for (TimeSeries.Usage c: TimeSeries.Usage.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
