
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "localTransformations",
    "timeSeries",
    "spectralAnalysis",
    "arima",
    "exponentialSmoothing",
    "seasonalTrendDecomposition",
    "modelVerification"
})
@XmlRootElement(name = "TimeSeriesModel", namespace = "http://www.dmg.org/PMML-4_3")
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
public class TimeSeriesModel
    extends Model
    implements HasExtensions<TimeSeriesModel>
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "bestFit", required = true)
    private TimeSeriesModel.Algorithm bestFit;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Extension
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    private ModelExplanation modelExplanation;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name = "TimeSeries", namespace = "http://www.dmg.org/PMML-4_3")
    private List<TimeSeries> timeSeries;
    @XmlElement(name = "SpectralAnalysis", namespace = "http://www.dmg.org/PMML-4_3")
    private SpectralAnalysis spectralAnalysis;
    @XmlElement(name = "ARIMA", namespace = "http://www.dmg.org/PMML-4_3")
    private org.dmg.pmml.time_series.ARIMA arima;
    @XmlElement(name = "ExponentialSmoothing", namespace = "http://www.dmg.org/PMML-4_3")
    private ExponentialSmoothing exponentialSmoothing;
    @XmlElement(name = "SeasonalTrendDecomposition", namespace = "http://www.dmg.org/PMML-4_3")
    private SeasonalTrendDecomposition seasonalTrendDecomposition;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305483L;

    public TimeSeriesModel() {
    }

    public TimeSeriesModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("bestFit")
        TimeSeriesModel.Algorithm bestFit,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningFunction = miningFunction;
        this.bestFit = bestFit;
        this.miningSchema = miningSchema;
    }

    public String getModelName() {
        return modelName;
    }

    public TimeSeriesModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public TimeSeriesModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public TimeSeriesModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public TimeSeriesModel.Algorithm getBestFit() {
        return bestFit;
    }

    public TimeSeriesModel setBestFit(
        @org.jpmml.model.annotations.Property("bestFit")
        TimeSeriesModel.Algorithm bestFit) {
        this.bestFit = bestFit;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public TimeSeriesModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public TimeSeriesModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public TimeSeriesModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public TimeSeriesModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public TimeSeriesModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    public TimeSeriesModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public TimeSeriesModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public List<TimeSeries> getTimeSeries() {
        if (timeSeries == null) {
            timeSeries = new ArrayList<TimeSeries>();
        }
        return this.timeSeries;
    }

    public SpectralAnalysis getSpectralAnalysis() {
        return spectralAnalysis;
    }

    public TimeSeriesModel setSpectralAnalysis(
        @org.jpmml.model.annotations.Property("spectralAnalysis")
        SpectralAnalysis spectralAnalysis) {
        this.spectralAnalysis = spectralAnalysis;
        return this;
    }

    public org.dmg.pmml.time_series.ARIMA getARIMA() {
        return arima;
    }

    public TimeSeriesModel setARIMA(
        @org.jpmml.model.annotations.Property("arima")
        org.dmg.pmml.time_series.ARIMA arima) {
        this.arima = arima;
        return this;
    }

    public ExponentialSmoothing getExponentialSmoothing() {
        return exponentialSmoothing;
    }

    public TimeSeriesModel setExponentialSmoothing(
        @org.jpmml.model.annotations.Property("exponentialSmoothing")
        ExponentialSmoothing exponentialSmoothing) {
        this.exponentialSmoothing = exponentialSmoothing;
        return this;
    }

    public SeasonalTrendDecomposition getSeasonalTrendDecomposition() {
        return seasonalTrendDecomposition;
    }

    public TimeSeriesModel setSeasonalTrendDecomposition(
        @org.jpmml.model.annotations.Property("seasonalTrendDecomposition")
        SeasonalTrendDecomposition seasonalTrendDecomposition) {
        this.seasonalTrendDecomposition = seasonalTrendDecomposition;
        return this;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public TimeSeriesModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TimeSeriesModel addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTimeSeries() {
        return ((this.timeSeries!= null)&&(this.timeSeries.size()> 0));
    }

    public TimeSeriesModel addTimeSeries(TimeSeries... timeSeries) {
        getTimeSeries().addAll(Arrays.asList(timeSeries));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTimeSeries()) {
                status = PMMLObject.traverse(visitor, getTimeSeries());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getSpectralAnalysis(), getARIMA(), getExponentialSmoothing(), getSeasonalTrendDecomposition(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Algorithm {

        ARIMA("ARIMA"),
        @XmlEnumValue("ExponentialSmoothing")
        EXPONENTIAL_SMOOTHING("ExponentialSmoothing"),
        @XmlEnumValue("SeasonalTrendDecomposition")
        SEASONAL_TREND_DECOMPOSITION("SeasonalTrendDecomposition"),
        @XmlEnumValue("SpectralAnalysis")
        SPECTRAL_ANALYSIS("SpectralAnalysis");
        private final String value;

        Algorithm(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TimeSeriesModel.Algorithm fromValue(String v) {
            for (TimeSeriesModel.Algorithm c: TimeSeriesModel.Algorithm.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
