
package org.dmg.pmml.time_series;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Array;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.Removed;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "array"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
public class TrendExpoSmooth
    extends org.dmg.pmml.PMMLObject
{

    @XmlAttribute(name = "trend")
    private TrendExpoSmooth.Trend trend;
    @XmlAttribute(name = "gamma")
    private Double gamma;
    @XmlAttribute(name = "phi")
    private Double phi;
    @XmlAttribute(name = "smoothedValue")
    @Optional((org.dmg.pmml.Version.PMML_4_1))
    private Double smoothedValue;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3")
    private Array array;
    private final static Double DEFAULT_PHI = 1.0D;
    private final static long serialVersionUID = 67305483L;

    public TrendExpoSmooth.Trend getTrend() {
        if (trend == null) {
            return TrendExpoSmooth.Trend.ADDITIVE;
        } else {
            return trend;
        }
    }

    public TrendExpoSmooth setTrend(
        @Property("trend")
        TrendExpoSmooth.Trend trend) {
        this.trend = trend;
        return this;
    }

    public Double getGamma() {
        return gamma;
    }

    public TrendExpoSmooth setGamma(
        @Property("gamma")
        Double gamma) {
        this.gamma = gamma;
        return this;
    }

    public Double getPhi() {
        if (phi == null) {
            return DEFAULT_PHI;
        } else {
            return phi;
        }
    }

    public TrendExpoSmooth setPhi(
        @Property("phi")
        Double phi) {
        this.phi = phi;
        return this;
    }

    public Double getSmoothedValue() {
        return smoothedValue;
    }

    public TrendExpoSmooth setSmoothedValue(
        @Property("smoothedValue")
        Double smoothedValue) {
        this.smoothedValue = smoothedValue;
        return this;
    }

    public Array getArray() {
        return array;
    }

    public TrendExpoSmooth setArray(
        @Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Trend {

        @XmlEnumValue("additive")
        ADDITIVE("additive"),
        @XmlEnumValue("damped_additive")
        DAMPED_ADDITIVE("damped_additive"),
        @XmlEnumValue("multiplicative")
        MULTIPLICATIVE("multiplicative"),
        @XmlEnumValue("damped_multiplicative")
        DAMPED_MULTIPLICATIVE("damped_multiplicative"),
        @XmlEnumValue("double_exponential")
        @Removed((org.dmg.pmml.Version.PMML_4_1))
        DOUBLE_EXPONENTIAL("double_exponential"),
        @XmlEnumValue("polynomial_exponential")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
        POLYNOMIAL_EXPONENTIAL("polynomial_exponential");
        private final String value;

        Trend(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TrendExpoSmooth.Trend fromValue(String v) {
            for (TrendExpoSmooth.Trend c: TrendExpoSmooth.Trend.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
