
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "AnovaRow", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "type",
    "sumOfSquares",
    "degreesOfFreedom",
    "meanOfSquares",
    "fValue",
    "pValue",
    "extensions"
})
public class AnovaRow
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<AnovaRow>
{

    @XmlAttribute(name = "type", required = true)
    @JsonProperty("type")
    private AnovaRow.Type type;
    @XmlAttribute(name = "sumOfSquares", required = true)
    @JsonProperty("sumOfSquares")
    private double sumOfSquares;
    @XmlAttribute(name = "degreesOfFreedom", required = true)
    @JsonProperty("degreesOfFreedom")
    private double degreesOfFreedom;
    @XmlAttribute(name = "meanOfSquares")
    @JsonProperty("meanOfSquares")
    private Double meanOfSquares;
    @XmlAttribute(name = "fValue")
    @JsonProperty("fValue")
    private Double fValue;
    @XmlAttribute(name = "pValue")
    @JsonProperty("pValue")
    private Double pValue;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305484L;

    public AnovaRow() {
    }

    public AnovaRow(
        @org.jpmml.model.annotations.Property("type")
        AnovaRow.Type type,
        @org.jpmml.model.annotations.Property("sumOfSquares")
        double sumOfSquares,
        @org.jpmml.model.annotations.Property("degreesOfFreedom")
        double degreesOfFreedom) {
        this.type = type;
        this.sumOfSquares = sumOfSquares;
        this.degreesOfFreedom = degreesOfFreedom;
    }

    public AnovaRow.Type getType() {
        return type;
    }

    public AnovaRow setType(
        @org.jpmml.model.annotations.Property("type")
        AnovaRow.Type type) {
        this.type = type;
        return this;
    }

    public double getSumOfSquares() {
        return sumOfSquares;
    }

    public AnovaRow setSumOfSquares(
        @org.jpmml.model.annotations.Property("sumOfSquares")
        double sumOfSquares) {
        this.sumOfSquares = sumOfSquares;
        return this;
    }

    public double getDegreesOfFreedom() {
        return degreesOfFreedom;
    }

    public AnovaRow setDegreesOfFreedom(
        @org.jpmml.model.annotations.Property("degreesOfFreedom")
        double degreesOfFreedom) {
        this.degreesOfFreedom = degreesOfFreedom;
        return this;
    }

    public Double getMeanOfSquares() {
        return meanOfSquares;
    }

    public AnovaRow setMeanOfSquares(
        @org.jpmml.model.annotations.Property("meanOfSquares")
        Double meanOfSquares) {
        this.meanOfSquares = meanOfSquares;
        return this;
    }

    public Double getFValue() {
        return fValue;
    }

    public AnovaRow setFValue(
        @org.jpmml.model.annotations.Property("fValue")
        Double fValue) {
        this.fValue = fValue;
        return this;
    }

    public Double getPValue() {
        return pValue;
    }

    public AnovaRow setPValue(
        @org.jpmml.model.annotations.Property("pValue")
        Double pValue) {
        this.pValue = pValue;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public AnovaRow addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Type
        implements StringValue<AnovaRow.Type>
    {

        @XmlEnumValue("Model")
        @JsonProperty("Model")
        MODEL("Model"),
        @XmlEnumValue("Error")
        @JsonProperty("Error")
        ERROR("Error"),
        @XmlEnumValue("Total")
        @JsonProperty("Total")
        TOTAL("Total");
        private final String value;

        Type(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static AnovaRow.Type fromValue(String v) {
            for (AnovaRow.Type c: AnovaRow.Type.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
