
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "dataFields",
    "taxonomies"
})
@XmlRootElement(name = "DataDictionary", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "numberOfFields",
    "extensions",
    "dataFields",
    "taxonomies"
})
public class DataDictionary
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<DataDictionary>
{

    @XmlAttribute(name = "numberOfFields")
    @JsonProperty("numberOfFields")
    private Integer numberOfFields;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "DataField", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("DataField")
    private List<DataField> dataFields;
    @XmlElement(name = "Taxonomy", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Taxonomy")
    private List<Taxonomy> taxonomies;
    private final static long serialVersionUID = 67305484L;

    public DataDictionary() {
    }

    public DataDictionary(
        @org.jpmml.model.annotations.Property("dataFields")
        List<DataField> dataFields) {
        this.dataFields = dataFields;
    }

    public Integer getNumberOfFields() {
        return numberOfFields;
    }

    public DataDictionary setNumberOfFields(
        @org.jpmml.model.annotations.Property("numberOfFields")
        Integer numberOfFields) {
        this.numberOfFields = numberOfFields;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<DataField> getDataFields() {
        if (dataFields == null) {
            dataFields = new ArrayList<DataField>();
        }
        return this.dataFields;
    }

    public List<Taxonomy> getTaxonomies() {
        if (taxonomies == null) {
            taxonomies = new ArrayList<Taxonomy>();
        }
        return this.taxonomies;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public DataDictionary addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasDataFields() {
        return ((this.dataFields!= null)&&(this.dataFields.size()> 0));
    }

    public DataDictionary addDataFields(DataField... dataFields) {
        getDataFields().addAll(Arrays.asList(dataFields));
        return this;
    }

    public boolean hasTaxonomies() {
        return ((this.taxonomies!= null)&&(this.taxonomies.size()> 0));
    }

    public DataDictionary addTaxonomies(Taxonomy... taxonomies) {
        getTaxonomies().addAll(Arrays.asList(taxonomies));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDataFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDataFields());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTaxonomies()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTaxonomies());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
