/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.jpmml.agent.InstrumentationProvider;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.visitors.AbstractVisitor;

public class MemoryMeasurer
extends AbstractVisitor {
    private Instrumentation instrumentation = InstrumentationProvider.getInstrumentation();
    private long size = 0L;
    private Set<Object> objects = Collections.newSetFromMap(new IdentityHashMap());

    @Override
    public void applyTo(Visitable visitable) {
        this.reset();
        super.applyTo(visitable);
    }

    @Override
    public VisitorAction visit(PMMLObject object) {
        this.measure(object);
        return super.visit(object);
    }

    public void reset() {
        this.size = 0L;
        this.objects.clear();
    }

    public long getSize() {
        return this.size;
    }

    public Set<Object> getObjects() {
        return this.objects;
    }

    private void measure(Object object) {
        boolean status = this.objects.add(object);
        if (!status) {
            return;
        }
        this.size += this.instrumentation.getObjectSize(object);
        Class<?> clazz = object.getClass();
        if (ReflectionUtil.isPrimitiveWrapper(clazz)) {
            return;
        }
        List<Field> fields = ReflectionUtil.getInstanceFields(clazz);
        for (Field field : fields) {
            Object value;
            Class<?> type = field.getType();
            if (type.isPrimitive() || !MemoryMeasurer.shouldMeasure(value = ReflectionUtil.getFieldValue(field, object))) continue;
            this.measure(value);
        }
        if (object instanceof Object[]) {
            Object[] values = (Object[])object;
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                if (!MemoryMeasurer.shouldMeasure(value)) continue;
                this.measure(value);
            }
        }
    }

    private static boolean shouldMeasure(Object object) {
        if (object != null) {
            Class<?> clazz = object.getClass();
            if (clazz.isEnum()) {
                return false;
            }
            if (object instanceof FieldName) {
                FieldName name = (FieldName)object;
                return !name.isInterned();
            }
            return !(object instanceof Visitable);
        }
        return false;
    }
}

