
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "indices",
    "entries"
})
@XmlRootElement(name = "REAL-SparseArray", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "n",
    "defaultValue",
    "indices",
    "entries"
})
public class RealSparseArray
    extends SparseArray<Double>
{

    @XmlAttribute(name = "n")
    @JsonProperty("n")
    private Integer n;
    @XmlAttribute(name = "defaultValue")
    @JsonProperty("defaultValue")
    private Double defaultValue;
    @XmlList
    @XmlElement(name = "Indices", namespace = "http://www.dmg.org/PMML-4_3", type = Integer.class)
    @JsonProperty("Indices")
    private List<Integer> indices;
    @XmlList
    @XmlElement(name = "REAL-Entries", namespace = "http://www.dmg.org/PMML-4_3", type = Double.class)
    @JsonProperty("REAL-Entries")
    private List<Double> entries;
    private final static Double DEFAULT_DEFAULT_VALUE = 0.0D;
    private final static long serialVersionUID = 67305485L;

    public Integer getN() {
        return n;
    }

    public RealSparseArray setN(
        @Property("n")
        Integer n) {
        this.n = n;
        return this;
    }

    public Double getDefaultValue() {
        if (defaultValue == null) {
            return DEFAULT_DEFAULT_VALUE;
        } else {
            return defaultValue;
        }
    }

    public RealSparseArray setDefaultValue(
        @Property("defaultValue")
        Double defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public boolean hasIndices() {
        return ((this.indices!= null)&&(this.indices.size()> 0));
    }

    public List<Integer> getIndices() {
        if (indices == null) {
            indices = new ArrayList<Integer>();
        }
        return this.indices;
    }

    public RealSparseArray addIndices(Integer... indices) {
        getIndices().addAll(Arrays.asList(indices));
        return this;
    }

    public boolean hasEntries() {
        return ((this.entries!= null)&&(this.entries.size()> 0));
    }

    public List<Double> getEntries() {
        if (entries == null) {
            entries = new ArrayList<Double>();
        }
        return this.entries;
    }

    public RealSparseArray addEntries(Double... entries) {
        getEntries().addAll(Arrays.asList(entries));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
