
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "counts",
    "numericInfo",
    "discrStats",
    "contStats",
    "anova"
})
@XmlRootElement(name = "UnivariateStats", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "field",
    "weighted",
    "extensions",
    "counts",
    "numericInfo",
    "discrStats",
    "contStats",
    "anova"
})
public class UnivariateStats
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<UnivariateStats> , HasFieldReference<UnivariateStats>
{

    @XmlAttribute(name = "field")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private FieldName field;
    @XmlAttribute(name = "weighted")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("weighted")
    private UnivariateStats.Weighted weighted;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Counts", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Counts")
    private Counts counts;
    @XmlElement(name = "NumericInfo", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("NumericInfo")
    private NumericInfo numericInfo;
    @XmlElement(name = "DiscrStats", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("DiscrStats")
    private DiscrStats discrStats;
    @XmlElement(name = "ContStats", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("ContStats")
    private ContStats contStats;
    @XmlElement(name = "Anova", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("Anova")
    private Anova anova;
    private final static long serialVersionUID = 67305485L;

    @Override
    public FieldName getField() {
        return field;
    }

    @Override
    public UnivariateStats setField(
        @Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public UnivariateStats.Weighted getWeighted() {
        if (weighted == null) {
            return UnivariateStats.Weighted.ZERO;
        } else {
            return weighted;
        }
    }

    public UnivariateStats setWeighted(
        @Property("weighted")
        UnivariateStats.Weighted weighted) {
        this.weighted = weighted;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public UnivariateStats addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Counts getCounts() {
        return counts;
    }

    public UnivariateStats setCounts(
        @Property("counts")
        Counts counts) {
        this.counts = counts;
        return this;
    }

    public NumericInfo getNumericInfo() {
        return numericInfo;
    }

    public UnivariateStats setNumericInfo(
        @Property("numericInfo")
        NumericInfo numericInfo) {
        this.numericInfo = numericInfo;
        return this;
    }

    public DiscrStats getDiscrStats() {
        return discrStats;
    }

    public UnivariateStats setDiscrStats(
        @Property("discrStats")
        DiscrStats discrStats) {
        this.discrStats = discrStats;
        return this;
    }

    public ContStats getContStats() {
        return contStats;
    }

    public UnivariateStats setContStats(
        @Property("contStats")
        ContStats contStats) {
        this.contStats = contStats;
        return this;
    }

    public Anova getAnova() {
        return anova;
    }

    public UnivariateStats setAnova(
        @Property("anova")
        Anova anova) {
        this.anova = anova;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCounts(), getNumericInfo(), getDiscrStats(), getContStats(), getAnova());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Weighted
        implements StringValue<UnivariateStats.Weighted>
    {

        @XmlEnumValue("0")
        @JsonProperty("0")
        ZERO("0"),
        @XmlEnumValue("1")
        @JsonProperty("1")
        ONE("1");
        private final String value;

        Weighted(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static UnivariateStats.Weighted fromValue(String v) {
            for (UnivariateStats.Weighted c: UnivariateStats.Weighted.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
