
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "correlationFields",
    "correlationValues",
    "correlationMethods"
})
@XmlRootElement(name = "Correlations", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "extensions",
    "correlationFields",
    "correlationValues",
    "correlationMethods"
})
public class Correlations
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Correlations>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "CorrelationFields", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("CorrelationFields")
    private CorrelationFields correlationFields;
    @XmlElement(name = "CorrelationValues", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("CorrelationValues")
    private CorrelationValues correlationValues;
    @XmlElement(name = "CorrelationMethods", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("CorrelationMethods")
    private CorrelationMethods correlationMethods;
    private final static long serialVersionUID = 67305486L;

    public Correlations() {
    }

    public Correlations(
        @org.jpmml.model.annotations.Property("correlationFields")
        CorrelationFields correlationFields,
        @org.jpmml.model.annotations.Property("correlationValues")
        CorrelationValues correlationValues) {
        this.correlationFields = correlationFields;
        this.correlationValues = correlationValues;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Correlations addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public CorrelationFields getCorrelationFields() {
        return correlationFields;
    }

    public Correlations setCorrelationFields(
        @org.jpmml.model.annotations.Property("correlationFields")
        CorrelationFields correlationFields) {
        this.correlationFields = correlationFields;
        return this;
    }

    public CorrelationValues getCorrelationValues() {
        return correlationValues;
    }

    public Correlations setCorrelationValues(
        @org.jpmml.model.annotations.Property("correlationValues")
        CorrelationValues correlationValues) {
        this.correlationValues = correlationValues;
        return this;
    }

    public CorrelationMethods getCorrelationMethods() {
        return correlationMethods;
    }

    public Correlations setCorrelationMethods(
        @org.jpmml.model.annotations.Property("correlationMethods")
        CorrelationMethods correlationMethods) {
        this.correlationMethods = correlationMethods;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCorrelationFields(), getCorrelationValues(), getCorrelationMethods());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
