
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "VerificationField", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "field",
    "column",
    "precision",
    "zeroThreshold",
    "extensions"
})
public class VerificationField
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<VerificationField> , HasFieldReference<VerificationField> , Indexable<org.dmg.pmml.FieldName>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private org.dmg.pmml.FieldName field;
    @XmlAttribute(name = "column")
    @JsonProperty("column")
    private String column;
    @XmlAttribute(name = "precision")
    @JsonProperty("precision")
    private Double precision;
    @XmlAttribute(name = "zeroThreshold")
    @JsonProperty("zeroThreshold")
    private Double zeroThreshold;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static Double DEFAULT_PRECISION = 1.0E-6D;
    private final static Double DEFAULT_ZERO_THRESHOLD = 1.0E-16D;
    private final static long serialVersionUID = 67305486L;

    public VerificationField() {
    }

    public VerificationField(
        @org.jpmml.model.annotations.Property("field")
        org.dmg.pmml.FieldName field) {
        this.field = field;
    }

    @Override
    public org.dmg.pmml.FieldName getKey() {
        return getField();
    }

    @Override
    public org.dmg.pmml.FieldName getField() {
        return field;
    }

    @Override
    public VerificationField setField(
        @org.jpmml.model.annotations.Property("field")
        org.dmg.pmml.FieldName field) {
        this.field = field;
        return this;
    }

    public String getColumn() {
        return column;
    }

    public VerificationField setColumn(
        @org.jpmml.model.annotations.Property("column")
        String column) {
        this.column = column;
        return this;
    }

    public Double getPrecision() {
        if (precision == null) {
            return DEFAULT_PRECISION;
        } else {
            return precision;
        }
    }

    public VerificationField setPrecision(
        @org.jpmml.model.annotations.Property("precision")
        Double precision) {
        this.precision = precision;
        return this;
    }

    public Double getZeroThreshold() {
        if (zeroThreshold == null) {
            return DEFAULT_ZERO_THRESHOLD;
        } else {
            return zeroThreshold;
        }
    }

    public VerificationField setZeroThreshold(
        @org.jpmml.model.annotations.Property("zeroThreshold")
        Double zeroThreshold) {
        this.zeroThreshold = zeroThreshold;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public VerificationField addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
