/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasExpression;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.TextIndexNormalization;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "textIndexNormalizations", "expression"})
@XmlRootElement(name="TextIndex", namespace="http://www.dmg.org/PMML-4_3")
@Added(value=Version.PMML_4_2)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"textField", "localTermWeights", "caseSensitive", "maxLevenshteinDistance", "countHits", "wordSeparatorCharacterRE", "tokenize", "extensions", "textIndexNormalizations", "expression"})
public class TextIndex
extends Expression
implements HasExpression<TextIndex>,
HasExtensions<TextIndex>,
HasFieldReference<TextIndex> {
    @XmlAttribute(name="textField", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="textField")
    private FieldName textField;
    @XmlAttribute(name="localTermWeights")
    @JsonProperty(value="localTermWeights")
    private LocalTermWeights localTermWeights;
    @XmlAttribute(name="isCaseSensitive")
    @JsonProperty(value="isCaseSensitive")
    private Boolean caseSensitive;
    @XmlAttribute(name="maxLevenshteinDistance")
    @JsonProperty(value="maxLevenshteinDistance")
    private Integer maxLevenshteinDistance;
    @XmlAttribute(name="countHits")
    @JsonProperty(value="countHits")
    private CountHits countHits;
    @XmlAttribute(name="wordSeparatorCharacterRE")
    @JsonProperty(value="wordSeparatorCharacterRE")
    private String wordSeparatorCharacterRE;
    @XmlAttribute(name="tokenize")
    @JsonProperty(value="tokenize")
    private Boolean tokenize;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="TextIndexNormalization", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="TextIndexNormalization")
    private List<TextIndexNormalization> textIndexNormalizations;
    @XmlElements(value={@XmlElement(name="Constant", namespace="http://www.dmg.org/PMML-4_3", type=Constant.class), @XmlElement(name="FieldRef", namespace="http://www.dmg.org/PMML-4_3", type=FieldRef.class), @XmlElement(name="NormContinuous", namespace="http://www.dmg.org/PMML-4_3", type=NormContinuous.class), @XmlElement(name="NormDiscrete", namespace="http://www.dmg.org/PMML-4_3", type=NormDiscrete.class), @XmlElement(name="Discretize", namespace="http://www.dmg.org/PMML-4_3", type=Discretize.class), @XmlElement(name="MapValues", namespace="http://www.dmg.org/PMML-4_3", type=MapValues.class), @XmlElement(name="TextIndex", namespace="http://www.dmg.org/PMML-4_3", type=TextIndex.class), @XmlElement(name="Apply", namespace="http://www.dmg.org/PMML-4_3", type=Apply.class), @XmlElement(name="Aggregate", namespace="http://www.dmg.org/PMML-4_3", type=Aggregate.class), @XmlElement(name="Lag", namespace="http://www.dmg.org/PMML-4_3", type=Lag.class)})
    @JsonProperty(value="Expression")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="Constant", value=Constant.class), @JsonSubTypes.Type(name="FieldRef", value=FieldRef.class), @JsonSubTypes.Type(name="NormContinuous", value=NormContinuous.class), @JsonSubTypes.Type(name="NormDiscrete", value=NormDiscrete.class), @JsonSubTypes.Type(name="Discretize", value=Discretize.class), @JsonSubTypes.Type(name="MapValues", value=MapValues.class), @JsonSubTypes.Type(name="TextIndex", value=TextIndex.class), @JsonSubTypes.Type(name="Apply", value=Apply.class), @JsonSubTypes.Type(name="Aggregate", value=Aggregate.class), @JsonSubTypes.Type(name="Lag", value=Lag.class)})
    private Expression expression;
    private static final Boolean DEFAULT_CASE_SENSITIVE = false;
    private static final Integer DEFAULT_MAX_LEVENSHTEIN_DISTANCE = 0;
    private static final Boolean DEFAULT_TOKENIZE = true;
    private static final long serialVersionUID = 67305486L;

    public TextIndex() {
    }

    public TextIndex(@Property(value="textField") FieldName textField) {
        this.textField = textField;
    }

    @Override
    public FieldName getField() {
        return this.getTextField();
    }

    @Override
    public TextIndex setField(FieldName field) {
        return this.setTextField(field);
    }

    public FieldName getTextField() {
        return this.textField;
    }

    public TextIndex setTextField(@Property(value="textField") FieldName textField) {
        this.textField = textField;
        return this;
    }

    public LocalTermWeights getLocalTermWeights() {
        if (this.localTermWeights == null) {
            return LocalTermWeights.TERM_FREQUENCY;
        }
        return this.localTermWeights;
    }

    public TextIndex setLocalTermWeights(@Property(value="localTermWeights") LocalTermWeights localTermWeights) {
        this.localTermWeights = localTermWeights;
        return this;
    }

    public boolean isCaseSensitive() {
        if (this.caseSensitive == null) {
            return DEFAULT_CASE_SENSITIVE;
        }
        return this.caseSensitive;
    }

    public TextIndex setCaseSensitive(@Property(value="caseSensitive") Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public Integer getMaxLevenshteinDistance() {
        if (this.maxLevenshteinDistance == null) {
            return DEFAULT_MAX_LEVENSHTEIN_DISTANCE;
        }
        return this.maxLevenshteinDistance;
    }

    public TextIndex setMaxLevenshteinDistance(@Property(value="maxLevenshteinDistance") Integer maxLevenshteinDistance) {
        this.maxLevenshteinDistance = maxLevenshteinDistance;
        return this;
    }

    public CountHits getCountHits() {
        if (this.countHits == null) {
            return CountHits.ALL_HITS;
        }
        return this.countHits;
    }

    public TextIndex setCountHits(@Property(value="countHits") CountHits countHits) {
        this.countHits = countHits;
        return this;
    }

    public String getWordSeparatorCharacterRE() {
        if (this.wordSeparatorCharacterRE == null) {
            return "\\s";
        }
        return this.wordSeparatorCharacterRE;
    }

    public TextIndex setWordSeparatorCharacterRE(@Property(value="wordSeparatorCharacterRE") String wordSeparatorCharacterRE) {
        this.wordSeparatorCharacterRE = wordSeparatorCharacterRE;
        return this;
    }

    public boolean isTokenize() {
        if (this.tokenize == null) {
            return DEFAULT_TOKENIZE;
        }
        return this.tokenize;
    }

    public TextIndex setTokenize(@Property(value="tokenize") Boolean tokenize) {
        this.tokenize = tokenize;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TextIndex addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTextIndexNormalizations() {
        return this.textIndexNormalizations != null && this.textIndexNormalizations.size() > 0;
    }

    public List<TextIndexNormalization> getTextIndexNormalizations() {
        if (this.textIndexNormalizations == null) {
            this.textIndexNormalizations = new ArrayList<TextIndexNormalization>();
        }
        return this.textIndexNormalizations;
    }

    public TextIndex addTextIndexNormalizations(TextIndexNormalization ... textIndexNormalizations) {
        this.getTextIndexNormalizations().addAll(Arrays.asList(textIndexNormalizations));
        return this;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public TextIndex setExpression(@Property(value="expression") Expression expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasTextIndexNormalizations()) {
                status = PMMLObject.traverse(visitor, this.getTextIndexNormalizations());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getExpression());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum LocalTermWeights implements StringValue<LocalTermWeights>
    {
        TERM_FREQUENCY("termFrequency"),
        BINARY("binary"),
        LOGARITHMIC("logarithmic"),
        AUGMENTED_NORMALIZED_TERM_FREQUENCY("augmentedNormalizedTermFrequency");

        private final String value;

        private LocalTermWeights(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static LocalTermWeights fromValue(String v) {
            for (LocalTermWeights c : LocalTermWeights.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum CountHits implements StringValue<CountHits>
    {
        ALL_HITS("allHits"),
        BEST_HITS("bestHits");

        private final String value;

        private CountHits(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static CountHits fromValue(String v) {
            for (CountHits c : CountHits.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

