
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "LinearNorm", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("LinearNorm")
@JsonPropertyOrder({
    "orig",
    "norm",
    "extensions"
})
public class LinearNorm
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<LinearNorm>
{

    @XmlAttribute(name = "orig", required = true)
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("orig")
    private Number orig;
    @XmlAttribute(name = "norm", required = true)
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("norm")
    private Number norm;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371009L;

    public LinearNorm() {
    }

    @ValueConstructor
    public LinearNorm(
        @org.jpmml.model.annotations.Property("orig")
        Number orig,
        @org.jpmml.model.annotations.Property("norm")
        Number norm) {
        this.orig = orig;
        this.norm = norm;
    }

    public Number getOrig() {
        return orig;
    }

    public LinearNorm setOrig(
        @org.jpmml.model.annotations.Property("orig")
        Number orig) {
        this.orig = orig;
        return this;
    }

    public Number getNorm() {
        return norm;
    }

    public LinearNorm setNorm(
        @org.jpmml.model.annotations.Property("norm")
        Number norm) {
        this.norm = norm;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public LinearNorm addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
