
package org.dmg.pmml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.Removed;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "CenterFields", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "derivedFields"
})
@Removed((org.dmg.pmml.Version.PMML_3_2))
@JsonRootName("CenterFields")
@JsonPropertyOrder({
    "derivedFields"
})
public class CenterFields
    extends org.dmg.pmml.PMMLObject
{

    @XmlElement(name = "DerivedField", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("DerivedField")
    private List<DerivedField> derivedFields;
    private final static long serialVersionUID = 67371009L;

    public CenterFields() {
    }

    @ValueConstructor
    public CenterFields(
        @Property("derivedFields")
        List<DerivedField> derivedFields) {
        this.derivedFields = derivedFields;
    }

    public boolean hasDerivedFields() {
        return ((this.derivedFields!= null)&&(this.derivedFields.size()> 0));
    }

    public List<DerivedField> getDerivedFields() {
        if (derivedFields == null) {
            derivedFields = new ArrayList<DerivedField>();
        }
        return this.derivedFields;
    }

    public CenterFields addDerivedFields(DerivedField... derivedFields) {
        getDerivedFields().addAll(Arrays.asList(derivedFields));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasDerivedFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDerivedFields());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
