
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Interval;
import org.dmg.pmml.Value;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlRootElement(name = "EventValues", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "values",
    "intervals"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonRootName("EventValues")
@JsonPropertyOrder({
    "extensions",
    "values",
    "intervals"
})
public class EventValues
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<EventValues>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Value", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Value")
    private List<Value> values;
    @XmlElement(name = "Interval", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Interval")
    private List<Interval> intervals;
    private final static long serialVersionUID = 67371009L;

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public EventValues addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasValues() {
        return ((this.values!= null)&&(this.values.size()> 0));
    }

    public List<Value> getValues() {
        if (values == null) {
            values = new ArrayList<Value>();
        }
        return this.values;
    }

    public EventValues addValues(Value... values) {
        getValues().addAll(Arrays.asList(values));
        return this;
    }

    public boolean hasIntervals() {
        return ((this.intervals!= null)&&(this.intervals.size()> 0));
    }

    public List<Interval> getIntervals() {
        if (intervals == null) {
            intervals = new ArrayList<Interval>();
        }
        return this.intervals;
    }

    public EventValues addIntervals(Interval... intervals) {
        getIntervals().addAll(Arrays.asList(intervals));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasValues()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getValues());
            }
            if ((status == VisitorAction.CONTINUE)&&hasIntervals()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getIntervals());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
