
package org.dmg.pmml.time_series;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "MaximumLikelihoodStat", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "kalmanState",
    "thetaRecursionState"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
@JsonRootName("MaximumLikelihoodStat")
@JsonPropertyOrder({
    "method",
    "periodDeficit",
    "kalmanState",
    "thetaRecursionState"
})
public class MaximumLikelihoodStat
    extends org.dmg.pmml.PMMLObject
{

    @XmlAttribute(name = "method", required = true)
    @JsonProperty("method")
    private String method;
    @XmlAttribute(name = "periodDeficit")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("periodDeficit")
    private Integer periodDeficit;
    @XmlElement(name = "KalmanState", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("KalmanState")
    private KalmanState kalmanState;
    @XmlElement(name = "ThetaRecursionState", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ThetaRecursionState")
    private ThetaRecursionState thetaRecursionState;
    private final static Integer DEFAULT_PERIOD_DEFICIT = new IntegerAdapter().unmarshal("0");
    private final static long serialVersionUID = 67371009L;

    public MaximumLikelihoodStat() {
    }

    @ValueConstructor
    public MaximumLikelihoodStat(
        @org.jpmml.model.annotations.Property("method")
        String method,
        @org.jpmml.model.annotations.Property("kalmanState")
        KalmanState kalmanState,
        @org.jpmml.model.annotations.Property("thetaRecursionState")
        ThetaRecursionState thetaRecursionState) {
        this.method = method;
        this.kalmanState = kalmanState;
        this.thetaRecursionState = thetaRecursionState;
    }

    public String getMethod() {
        return method;
    }

    public MaximumLikelihoodStat setMethod(
        @org.jpmml.model.annotations.Property("method")
        String method) {
        this.method = method;
        return this;
    }

    public Integer getPeriodDeficit() {
        if (periodDeficit == null) {
            return DEFAULT_PERIOD_DEFICIT;
        } else {
            return periodDeficit;
        }
    }

    public MaximumLikelihoodStat setPeriodDeficit(
        @org.jpmml.model.annotations.Property("periodDeficit")
        Integer periodDeficit) {
        this.periodDeficit = periodDeficit;
        return this;
    }

    public KalmanState getKalmanState() {
        return kalmanState;
    }

    public MaximumLikelihoodStat setKalmanState(
        @org.jpmml.model.annotations.Property("kalmanState")
        KalmanState kalmanState) {
        this.kalmanState = kalmanState;
        return this;
    }

    public ThetaRecursionState getThetaRecursionState() {
        return thetaRecursionState;
    }

    public MaximumLikelihoodStat setThetaRecursionState(
        @org.jpmml.model.annotations.Property("thetaRecursionState")
        ThetaRecursionState thetaRecursionState) {
        this.thetaRecursionState = thetaRecursionState;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getKalmanState(), getThetaRecursionState());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
