
package org.dmg.pmml.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "TreeModel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "node",
    "modelVerification"
})
@JsonRootName("TreeModel")
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "missingValueStrategy",
    "missingValuePenalty",
    "noTrueChildStrategy",
    "splitCharacteristic",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "node",
    "modelVerification"
})
public class TreeModel
    extends Model
    implements HasExtensions<TreeModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "missingValueStrategy")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("missingValueStrategy")
    private TreeModel.MissingValueStrategy missingValueStrategy;
    @XmlAttribute(name = "missingValuePenalty")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("missingValuePenalty")
    private Number missingValuePenalty;
    @XmlAttribute(name = "noTrueChildStrategy")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("noTrueChildStrategy")
    private TreeModel.NoTrueChildStrategy noTrueChildStrategy;
    @XmlAttribute(name = "splitCharacteristic")
    @JsonProperty("splitCharacteristic")
    private TreeModel.SplitCharacteristic splitCharacteristic;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("isScorable")
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.XPMML))
    @JsonProperty("x-mathContext")
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "Node", namespace = "http://www.dmg.org/PMML-4_4", required = true, type = org.dmg.pmml.tree.ComplexNode.class)
    @JsonProperty("Node")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "Node", value = org.dmg.pmml.tree.ComplexNode.class)
    })
    private Node node;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private final static Number DEFAULT_MISSING_VALUE_PENALTY = new ProbabilityNumberAdapter().unmarshal("1.0");
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67371009L;

    public TreeModel() {
    }

    @ValueConstructor
    public TreeModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("node")
        Node node) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.node = node;
    }

    public String getModelName() {
        return modelName;
    }

    public TreeModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public TreeModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public TreeModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public TreeModel.MissingValueStrategy getMissingValueStrategy() {
        if (missingValueStrategy == null) {
            return TreeModel.MissingValueStrategy.NONE;
        } else {
            return missingValueStrategy;
        }
    }

    public TreeModel setMissingValueStrategy(
        @org.jpmml.model.annotations.Property("missingValueStrategy")
        TreeModel.MissingValueStrategy missingValueStrategy) {
        this.missingValueStrategy = missingValueStrategy;
        return this;
    }

    public Number getMissingValuePenalty() {
        if (missingValuePenalty == null) {
            return DEFAULT_MISSING_VALUE_PENALTY;
        } else {
            return missingValuePenalty;
        }
    }

    public TreeModel setMissingValuePenalty(
        @org.jpmml.model.annotations.Property("missingValuePenalty")
        Number missingValuePenalty) {
        this.missingValuePenalty = missingValuePenalty;
        return this;
    }

    public TreeModel.NoTrueChildStrategy getNoTrueChildStrategy() {
        if (noTrueChildStrategy == null) {
            return TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION;
        } else {
            return noTrueChildStrategy;
        }
    }

    public TreeModel setNoTrueChildStrategy(
        @org.jpmml.model.annotations.Property("noTrueChildStrategy")
        TreeModel.NoTrueChildStrategy noTrueChildStrategy) {
        this.noTrueChildStrategy = noTrueChildStrategy;
        return this;
    }

    public TreeModel.SplitCharacteristic getSplitCharacteristic() {
        if (splitCharacteristic == null) {
            return TreeModel.SplitCharacteristic.MULTI_SPLIT;
        } else {
            return splitCharacteristic;
        }
    }

    public TreeModel setSplitCharacteristic(
        @org.jpmml.model.annotations.Property("splitCharacteristic")
        TreeModel.SplitCharacteristic splitCharacteristic) {
        this.splitCharacteristic = splitCharacteristic;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public TreeModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public TreeModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TreeModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public TreeModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public TreeModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public TreeModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    public TreeModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    public Targets getTargets() {
        return targets;
    }

    public TreeModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public TreeModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Node getNode() {
        return node;
    }

    public TreeModel setNode(
        @org.jpmml.model.annotations.Property("node")
        Node node) {
        this.node = node;
        return this;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public TreeModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getNode(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum MissingValueStrategy
        implements StringValue<TreeModel.MissingValueStrategy>
    {

        @XmlEnumValue("lastPrediction")
        @JsonProperty("lastPrediction")
        LAST_PREDICTION("lastPrediction"),
        @XmlEnumValue("nullPrediction")
        @JsonProperty("nullPrediction")
        NULL_PREDICTION("nullPrediction"),
        @XmlEnumValue("defaultChild")
        @JsonProperty("defaultChild")
        DEFAULT_CHILD("defaultChild"),
        @XmlEnumValue("weightedConfidence")
        @JsonProperty("weightedConfidence")
        WEIGHTED_CONFIDENCE("weightedConfidence"),
        @XmlEnumValue("aggregateNodes")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
        @JsonProperty("aggregateNodes")
        AGGREGATE_NODES("aggregateNodes"),
        @XmlEnumValue("none")
        @JsonProperty("none")
        NONE("none");
        private final String value;

        MissingValueStrategy(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TreeModel.MissingValueStrategy fromValue(String v) {
            for (TreeModel.MissingValueStrategy c: TreeModel.MissingValueStrategy.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum NoTrueChildStrategy
        implements StringValue<TreeModel.NoTrueChildStrategy>
    {

        @XmlEnumValue("returnNullPrediction")
        @JsonProperty("returnNullPrediction")
        RETURN_NULL_PREDICTION("returnNullPrediction"),
        @XmlEnumValue("returnLastPrediction")
        @JsonProperty("returnLastPrediction")
        RETURN_LAST_PREDICTION("returnLastPrediction");
        private final String value;

        NoTrueChildStrategy(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TreeModel.NoTrueChildStrategy fromValue(String v) {
            for (TreeModel.NoTrueChildStrategy c: TreeModel.NoTrueChildStrategy.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum SplitCharacteristic
        implements StringValue<TreeModel.SplitCharacteristic>
    {

        @XmlEnumValue("binarySplit")
        @JsonProperty("binarySplit")
        BINARY_SPLIT("binarySplit"),
        @XmlEnumValue("multiSplit")
        @JsonProperty("multiSplit")
        MULTI_SPLIT("multiSplit");
        private final String value;

        SplitCharacteristic(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TreeModel.SplitCharacteristic fromValue(String v) {
            for (TreeModel.SplitCharacteristic c: TreeModel.SplitCharacteristic.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
