/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Array;
import org.dmg.pmml.MatCell;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Matrix", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"arrays", "matCells"})
@JsonRootName(value="Matrix")
@JsonPropertyOrder(value={"kind", "nbRows", "nbCols", "diagDefault", "offDiagDefault", "arrays", "matCells"})
public class Matrix
extends PMMLObject {
    @XmlAttribute(name="kind")
    @JsonProperty(value="kind")
    private Kind kind;
    @XmlAttribute(name="nbRows")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @JsonProperty(value="nbRows")
    private Integer nbRows;
    @XmlAttribute(name="nbCols")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @JsonProperty(value="nbCols")
    private Integer nbCols;
    @XmlAttribute(name="diagDefault")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="diagDefault")
    private Number diagDefault;
    @XmlAttribute(name="offDiagDefault")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="offDiagDefault")
    private Number offDiagDefault;
    @XmlElement(name="Array", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Array")
    private List<Array> arrays;
    @XmlElement(name="MatCell", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="MatCell")
    private List<MatCell> matCells;
    private static final long serialVersionUID = 0x4040001L;

    public Matrix() {
    }

    @ValueConstructor
    public Matrix(@Property(value="arrays") List<Array> arrays, @Property(value="matCells") List<MatCell> matCells) {
        this.arrays = arrays;
        this.matCells = matCells;
    }

    public Kind getKind() {
        if (this.kind == null) {
            return Kind.ANY;
        }
        return this.kind;
    }

    public Matrix setKind(@Property(value="kind") Kind kind) {
        this.kind = kind;
        return this;
    }

    public Integer getNbRows() {
        return this.nbRows;
    }

    public Matrix setNbRows(@Property(value="nbRows") Integer nbRows) {
        this.nbRows = nbRows;
        return this;
    }

    public Integer getNbCols() {
        return this.nbCols;
    }

    public Matrix setNbCols(@Property(value="nbCols") Integer nbCols) {
        this.nbCols = nbCols;
        return this;
    }

    public Number getDiagDefault() {
        return this.diagDefault;
    }

    public Matrix setDiagDefault(@Property(value="diagDefault") Number diagDefault) {
        this.diagDefault = diagDefault;
        return this;
    }

    public Number getOffDiagDefault() {
        return this.offDiagDefault;
    }

    public Matrix setOffDiagDefault(@Property(value="offDiagDefault") Number offDiagDefault) {
        this.offDiagDefault = offDiagDefault;
        return this;
    }

    public boolean hasArrays() {
        return this.arrays != null && this.arrays.size() > 0;
    }

    public List<Array> getArrays() {
        if (this.arrays == null) {
            this.arrays = new ArrayList<Array>();
        }
        return this.arrays;
    }

    public Matrix addArrays(Array ... arrays) {
        this.getArrays().addAll(Arrays.asList(arrays));
        return this;
    }

    public boolean hasMatCells() {
        return this.matCells != null && this.matCells.size() > 0;
    }

    public List<MatCell> getMatCells() {
        if (this.matCells == null) {
            this.matCells = new ArrayList<MatCell>();
        }
        return this.matCells;
    }

    public Matrix addMatCells(MatCell ... matCells) {
        this.getMatCells().addAll(Arrays.asList(matCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasArrays()) {
                status = PMMLObject.traverse(visitor, this.getArrays());
            }
            if (status == VisitorAction.CONTINUE && this.hasMatCells()) {
                status = PMMLObject.traverse(visitor, this.getMatCells());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Kind implements StringValue<Kind>
    {
        DIAGONAL("diagonal"),
        SYMMETRIC("symmetric"),
        ANY("any");

        private final String value;

        private Kind(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Kind fromValue(String v) {
            for (Kind c : Kind.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

