
package org.dmg.pmml.association;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.HasId;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Item", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("Item")
@JsonPropertyOrder({
    "id",
    "value",
    "field",
    "category",
    "mappedValue",
    "weight",
    "extensions"
})
public class Item
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Item> , HasFieldReference<Item> , HasId<Item, String> , Indexable<String>
{

    @XmlAttribute(name = "id", required = true)
    @JsonProperty("id")
    private String id;
    @XmlAttribute(name = "value", required = true)
    @JsonProperty("value")
    private String value;
    @XmlAttribute(name = "field")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_3))
    @JsonProperty("field")
    private FieldName field;
    @XmlAttribute(name = "category")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_3))
    @JsonProperty("category")
    private String category;
    @XmlAttribute(name = "mappedValue")
    @JsonProperty("mappedValue")
    private String mappedValue;
    @XmlAttribute(name = "weight")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("weight")
    private Number weight;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371010L;

    public Item() {
    }

    @ValueConstructor
    public Item(
        @org.jpmml.model.annotations.Property("id")
        String id,
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.id = id;
        this.value = value;
    }

    @Override
    public String getKey() {
        return getId();
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public Item setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public String getValue() {
        return value;
    }

    public Item setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    @Override
    public FieldName getField() {
        return field;
    }

    @Override
    public Item setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public String getCategory() {
        return category;
    }

    public Item setCategory(
        @org.jpmml.model.annotations.Property("category")
        String category) {
        this.category = category;
        return this;
    }

    public String getMappedValue() {
        return mappedValue;
    }

    public Item setMappedValue(
        @org.jpmml.model.annotations.Property("mappedValue")
        String mappedValue) {
        this.mappedValue = mappedValue;
        return this;
    }

    public Number getWeight() {
        return weight;
    }

    public Item setWeight(
        @org.jpmml.model.annotations.Property("weight")
        Number weight) {
        this.weight = weight;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Item addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
