
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "Constraints", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_3_1))
@JsonRootName("Constraints")
@JsonPropertyOrder({
    "minimumNumberOfItems",
    "maximumNumberOfItems",
    "minimumNumberOfAntecedentItems",
    "maximumNumberOfAntecedentItems",
    "minimumNumberOfConsequentItems",
    "maximumNumberOfConsequentItems",
    "minimumSupport",
    "minimumConfidence",
    "minimumLift",
    "minimumTotalSequenceTime",
    "maximumTotalSequenceTime",
    "minimumItemsetSeparationTime",
    "maximumItemsetSeparationTime",
    "minimumAntConsSeparationTime",
    "maximumAntConsSeparationTime",
    "extensions"
})
public class Constraints
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Constraints>
{

    @XmlAttribute(name = "minimumNumberOfItems")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("minimumNumberOfItems")
    private Integer minimumNumberOfItems;
    @XmlAttribute(name = "maximumNumberOfItems")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("maximumNumberOfItems")
    private Integer maximumNumberOfItems;
    @XmlAttribute(name = "minimumNumberOfAntecedentItems")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("minimumNumberOfAntecedentItems")
    private Integer minimumNumberOfAntecedentItems;
    @XmlAttribute(name = "maximumNumberOfAntecedentItems")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("maximumNumberOfAntecedentItems")
    private Integer maximumNumberOfAntecedentItems;
    @XmlAttribute(name = "minimumNumberOfConsequentItems")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("minimumNumberOfConsequentItems")
    private Integer minimumNumberOfConsequentItems;
    @XmlAttribute(name = "maximumNumberOfConsequentItems")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("maximumNumberOfConsequentItems")
    private Integer maximumNumberOfConsequentItems;
    @XmlAttribute(name = "minimumSupport")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("minimumSupport")
    private Number minimumSupport;
    @XmlAttribute(name = "minimumConfidence")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("minimumConfidence")
    private Number minimumConfidence;
    @XmlAttribute(name = "minimumLift")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("minimumLift")
    private Number minimumLift;
    @XmlAttribute(name = "minimumTotalSequenceTime")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("minimumTotalSequenceTime")
    private Number minimumTotalSequenceTime;
    @XmlAttribute(name = "maximumTotalSequenceTime")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("maximumTotalSequenceTime")
    private Number maximumTotalSequenceTime;
    @XmlAttribute(name = "minimumItemsetSeparationTime")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("minimumItemsetSeparationTime")
    private Number minimumItemsetSeparationTime;
    @XmlAttribute(name = "maximumItemsetSeparationTime")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("maximumItemsetSeparationTime")
    private Number maximumItemsetSeparationTime;
    @XmlAttribute(name = "minimumAntConsSeparationTime")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("minimumAntConsSeparationTime")
    private Number minimumAntConsSeparationTime;
    @XmlAttribute(name = "maximumAntConsSeparationTime")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("maximumAntConsSeparationTime")
    private Number maximumAntConsSeparationTime;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static Integer DEFAULT_MINIMUM_NUMBER_OF_ITEMS = new NonNegativeIntegerAdapter().unmarshal("1");
    private final static Integer DEFAULT_MINIMUM_NUMBER_OF_ANTECEDENT_ITEMS = new NonNegativeIntegerAdapter().unmarshal("1");
    private final static Integer DEFAULT_MINIMUM_NUMBER_OF_CONSEQUENT_ITEMS = new NonNegativeIntegerAdapter().unmarshal("1");
    private final static Number DEFAULT_MINIMUM_SUPPORT = new RealNumberAdapter().unmarshal("0");
    private final static Number DEFAULT_MINIMUM_CONFIDENCE = new RealNumberAdapter().unmarshal("0");
    private final static Number DEFAULT_MINIMUM_LIFT = new RealNumberAdapter().unmarshal("0");
    private final static Number DEFAULT_MINIMUM_TOTAL_SEQUENCE_TIME = new RealNumberAdapter().unmarshal("0");
    private final static Number DEFAULT_MINIMUM_ITEMSET_SEPARATION_TIME = new RealNumberAdapter().unmarshal("0");
    private final static Number DEFAULT_MINIMUM_ANT_CONS_SEPARATION_TIME = new RealNumberAdapter().unmarshal("0");
    private final static long serialVersionUID = 67371010L;

    public Integer getMinimumNumberOfItems() {
        if (minimumNumberOfItems == null) {
            return DEFAULT_MINIMUM_NUMBER_OF_ITEMS;
        } else {
            return minimumNumberOfItems;
        }
    }

    public Constraints setMinimumNumberOfItems(
        @Property("minimumNumberOfItems")
        Integer minimumNumberOfItems) {
        this.minimumNumberOfItems = minimumNumberOfItems;
        return this;
    }

    public Integer getMaximumNumberOfItems() {
        return maximumNumberOfItems;
    }

    public Constraints setMaximumNumberOfItems(
        @Property("maximumNumberOfItems")
        Integer maximumNumberOfItems) {
        this.maximumNumberOfItems = maximumNumberOfItems;
        return this;
    }

    public Integer getMinimumNumberOfAntecedentItems() {
        if (minimumNumberOfAntecedentItems == null) {
            return DEFAULT_MINIMUM_NUMBER_OF_ANTECEDENT_ITEMS;
        } else {
            return minimumNumberOfAntecedentItems;
        }
    }

    public Constraints setMinimumNumberOfAntecedentItems(
        @Property("minimumNumberOfAntecedentItems")
        Integer minimumNumberOfAntecedentItems) {
        this.minimumNumberOfAntecedentItems = minimumNumberOfAntecedentItems;
        return this;
    }

    public Integer getMaximumNumberOfAntecedentItems() {
        return maximumNumberOfAntecedentItems;
    }

    public Constraints setMaximumNumberOfAntecedentItems(
        @Property("maximumNumberOfAntecedentItems")
        Integer maximumNumberOfAntecedentItems) {
        this.maximumNumberOfAntecedentItems = maximumNumberOfAntecedentItems;
        return this;
    }

    public Integer getMinimumNumberOfConsequentItems() {
        if (minimumNumberOfConsequentItems == null) {
            return DEFAULT_MINIMUM_NUMBER_OF_CONSEQUENT_ITEMS;
        } else {
            return minimumNumberOfConsequentItems;
        }
    }

    public Constraints setMinimumNumberOfConsequentItems(
        @Property("minimumNumberOfConsequentItems")
        Integer minimumNumberOfConsequentItems) {
        this.minimumNumberOfConsequentItems = minimumNumberOfConsequentItems;
        return this;
    }

    public Integer getMaximumNumberOfConsequentItems() {
        return maximumNumberOfConsequentItems;
    }

    public Constraints setMaximumNumberOfConsequentItems(
        @Property("maximumNumberOfConsequentItems")
        Integer maximumNumberOfConsequentItems) {
        this.maximumNumberOfConsequentItems = maximumNumberOfConsequentItems;
        return this;
    }

    public Number getMinimumSupport() {
        if (minimumSupport == null) {
            return DEFAULT_MINIMUM_SUPPORT;
        } else {
            return minimumSupport;
        }
    }

    public Constraints setMinimumSupport(
        @Property("minimumSupport")
        Number minimumSupport) {
        this.minimumSupport = minimumSupport;
        return this;
    }

    public Number getMinimumConfidence() {
        if (minimumConfidence == null) {
            return DEFAULT_MINIMUM_CONFIDENCE;
        } else {
            return minimumConfidence;
        }
    }

    public Constraints setMinimumConfidence(
        @Property("minimumConfidence")
        Number minimumConfidence) {
        this.minimumConfidence = minimumConfidence;
        return this;
    }

    public Number getMinimumLift() {
        if (minimumLift == null) {
            return DEFAULT_MINIMUM_LIFT;
        } else {
            return minimumLift;
        }
    }

    public Constraints setMinimumLift(
        @Property("minimumLift")
        Number minimumLift) {
        this.minimumLift = minimumLift;
        return this;
    }

    public Number getMinimumTotalSequenceTime() {
        if (minimumTotalSequenceTime == null) {
            return DEFAULT_MINIMUM_TOTAL_SEQUENCE_TIME;
        } else {
            return minimumTotalSequenceTime;
        }
    }

    public Constraints setMinimumTotalSequenceTime(
        @Property("minimumTotalSequenceTime")
        Number minimumTotalSequenceTime) {
        this.minimumTotalSequenceTime = minimumTotalSequenceTime;
        return this;
    }

    public Number getMaximumTotalSequenceTime() {
        return maximumTotalSequenceTime;
    }

    public Constraints setMaximumTotalSequenceTime(
        @Property("maximumTotalSequenceTime")
        Number maximumTotalSequenceTime) {
        this.maximumTotalSequenceTime = maximumTotalSequenceTime;
        return this;
    }

    public Number getMinimumItemsetSeparationTime() {
        if (minimumItemsetSeparationTime == null) {
            return DEFAULT_MINIMUM_ITEMSET_SEPARATION_TIME;
        } else {
            return minimumItemsetSeparationTime;
        }
    }

    public Constraints setMinimumItemsetSeparationTime(
        @Property("minimumItemsetSeparationTime")
        Number minimumItemsetSeparationTime) {
        this.minimumItemsetSeparationTime = minimumItemsetSeparationTime;
        return this;
    }

    public Number getMaximumItemsetSeparationTime() {
        return maximumItemsetSeparationTime;
    }

    public Constraints setMaximumItemsetSeparationTime(
        @Property("maximumItemsetSeparationTime")
        Number maximumItemsetSeparationTime) {
        this.maximumItemsetSeparationTime = maximumItemsetSeparationTime;
        return this;
    }

    public Number getMinimumAntConsSeparationTime() {
        if (minimumAntConsSeparationTime == null) {
            return DEFAULT_MINIMUM_ANT_CONS_SEPARATION_TIME;
        } else {
            return minimumAntConsSeparationTime;
        }
    }

    public Constraints setMinimumAntConsSeparationTime(
        @Property("minimumAntConsSeparationTime")
        Number minimumAntConsSeparationTime) {
        this.minimumAntConsSeparationTime = minimumAntConsSeparationTime;
        return this;
    }

    public Number getMaximumAntConsSeparationTime() {
        return maximumAntConsSeparationTime;
    }

    public Constraints setMaximumAntConsSeparationTime(
        @Property("maximumAntConsSeparationTime")
        Number maximumAntConsSeparationTime) {
        this.maximumAntConsSeparationTime = maximumAntConsSeparationTime;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Constraints addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
