
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasId;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Sequence", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "setReference",
    "content",
    "time"
})
@JsonRootName("Sequence")
@JsonPropertyOrder({
    "id",
    "numberOfSets",
    "occurrence",
    "support",
    "extensions",
    "setReference",
    "content",
    "time"
})
public class Sequence
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Sequence> , HasId<Sequence, String> , Indexable<String>
{

    @XmlAttribute(name = "id", required = true)
    @JsonProperty("id")
    private String id;
    @XmlAttribute(name = "numberOfSets")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfSets")
    private Integer numberOfSets;
    @XmlAttribute(name = "occurrence")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("occurrence")
    private Integer occurrence;
    @XmlAttribute(name = "support")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("support")
    private Number support;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "SetReference", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("SetReference")
    private org.dmg.pmml.sequence.SetReference setReference;
    @XmlElements({
        @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Extension.class),
        @XmlElement(name = "Delimiter", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.sequence.Delimiter.class),
        @XmlElement(name = "Time", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.sequence.Time.class),
        @XmlElement(name = "SetReference", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.sequence.SetReference.class)
    })
    @JsonProperty("content")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "Extension", value = org.dmg.pmml.Extension.class),
        @JsonSubTypes.Type(name = "Delimiter", value = org.dmg.pmml.sequence.Delimiter.class),
        @JsonSubTypes.Type(name = "Time", value = org.dmg.pmml.sequence.Time.class),
        @JsonSubTypes.Type(name = "SetReference", value = org.dmg.pmml.sequence.SetReference.class)
    })
    private List<org.dmg.pmml.PMMLObject> content;
    @XmlElement(name = "Time", namespace = "http://www.dmg.org/PMML-4_4")
    @Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("Time")
    private org.dmg.pmml.sequence.Time time;
    private final static long serialVersionUID = 67371010L;

    public Sequence() {
    }

    @ValueConstructor
    public Sequence(
        @org.jpmml.model.annotations.Property("id")
        String id,
        @org.jpmml.model.annotations.Property("setReference")
        org.dmg.pmml.sequence.SetReference setReference) {
        this.id = id;
        this.setReference = setReference;
    }

    @Override
    public String getKey() {
        return getId();
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public Sequence setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public Integer getNumberOfSets() {
        return numberOfSets;
    }

    public Sequence setNumberOfSets(
        @org.jpmml.model.annotations.Property("numberOfSets")
        Integer numberOfSets) {
        this.numberOfSets = numberOfSets;
        return this;
    }

    public Integer getOccurrence() {
        return occurrence;
    }

    public Sequence setOccurrence(
        @org.jpmml.model.annotations.Property("occurrence")
        Integer occurrence) {
        this.occurrence = occurrence;
        return this;
    }

    public Number getSupport() {
        return support;
    }

    public Sequence setSupport(
        @org.jpmml.model.annotations.Property("support")
        Number support) {
        this.support = support;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    @Override
    public Sequence addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public org.dmg.pmml.sequence.SetReference getSetReference() {
        return setReference;
    }

    public Sequence setSetReference(
        @org.jpmml.model.annotations.Property("setReference")
        org.dmg.pmml.sequence.SetReference setReference) {
        this.setReference = setReference;
        return this;
    }

    public boolean hasContent() {
        return ((this.content!= null)&&(this.content.size()> 0));
    }

    public List<org.dmg.pmml.PMMLObject> getContent() {
        if (content == null) {
            content = new ArrayList<org.dmg.pmml.PMMLObject>();
        }
        return this.content;
    }

    public Sequence addContent(org.dmg.pmml.PMMLObject... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    public org.dmg.pmml.sequence.Time getTime() {
        return time;
    }

    public Sequence setTime(
        @org.jpmml.model.annotations.Property("time")
        org.dmg.pmml.sequence.Time time) {
        this.time = time;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSetReference());
            }
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContent());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTime());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
