/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.adapters;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.dmg.pmml.adapters.NumberUtil;

public class NumberAdapter
extends XmlAdapter<String, Number> {
    public Number unmarshal(String value) {
        Number result = NumberUtil.parseNumber(value);
        if (!NumberAdapter.isValid(result)) {
            throw new IllegalArgumentException(value);
        }
        return result;
    }

    public String marshal(Number value) {
        if (value == null) {
            return null;
        }
        return NumberUtil.printNumber(value);
    }

    public static boolean isValid(Number value) {
        Double doubleValue;
        Float floatValue;
        return !(value instanceof Float ? (floatValue = (Float)value).isNaN() || floatValue.isInfinite() : value instanceof Double && ((doubleValue = (Double)value).isNaN() || doubleValue.isInfinite()));
    }
}

