
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "OptimumLiftGraph", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "liftGraph"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonRootName("OptimumLiftGraph")
@JsonPropertyOrder({
    "extensions",
    "liftGraph"
})
public class OptimumLiftGraph
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<OptimumLiftGraph>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "LiftGraph", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("LiftGraph")
    private LiftGraph liftGraph;
    private final static long serialVersionUID = 67371267L;

    public OptimumLiftGraph() {
    }

    @ValueConstructor
    public OptimumLiftGraph(
        @org.jpmml.model.annotations.Property("liftGraph")
        LiftGraph liftGraph) {
        this.liftGraph = liftGraph;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public OptimumLiftGraph addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public LiftGraph getLiftGraph() {
        return liftGraph;
    }

    public OptimumLiftGraph setLiftGraph(
        @org.jpmml.model.annotations.Property("liftGraph")
        LiftGraph liftGraph) {
        this.liftGraph = liftGraph;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getLiftGraph());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
