
package org.dmg.pmml.association;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "AssociationRule", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("AssociationRule")
@JsonPropertyOrder({
    "antecedent",
    "consequent",
    "support",
    "confidence",
    "lift",
    "leverage",
    "affinity",
    "id",
    "extensions"
})
public class AssociationRule
    extends Entity<String>
    implements HasExtensions<AssociationRule>
{

    @XmlAttribute(name = "antecedent", required = true)
    @JsonProperty("antecedent")
    private String antecedent;
    @XmlAttribute(name = "consequent", required = true)
    @JsonProperty("consequent")
    private String consequent;
    @XmlAttribute(name = "support", required = true)
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @JsonProperty("support")
    private Number support;
    @XmlAttribute(name = "confidence", required = true)
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @JsonProperty("confidence")
    private Number confidence;
    @XmlAttribute(name = "lift")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("lift")
    private Number lift;
    @XmlAttribute(name = "leverage")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("leverage")
    private Number leverage;
    @XmlAttribute(name = "affinity")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("affinity")
    private Number affinity;
    @XmlAttribute(name = "id")
    @JsonProperty("id")
    private String id;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371267L;

    public AssociationRule() {
    }

    @ValueConstructor
    public AssociationRule(
        @org.jpmml.model.annotations.Property("antecedent")
        String antecedent,
        @org.jpmml.model.annotations.Property("consequent")
        String consequent,
        @org.jpmml.model.annotations.Property("support")
        Number support,
        @org.jpmml.model.annotations.Property("confidence")
        Number confidence) {
        this.antecedent = antecedent;
        this.consequent = consequent;
        this.support = support;
        this.confidence = confidence;
    }

    public String getAntecedent() {
        return antecedent;
    }

    public AssociationRule setAntecedent(
        @org.jpmml.model.annotations.Property("antecedent")
        String antecedent) {
        this.antecedent = antecedent;
        return this;
    }

    public String getConsequent() {
        return consequent;
    }

    public AssociationRule setConsequent(
        @org.jpmml.model.annotations.Property("consequent")
        String consequent) {
        this.consequent = consequent;
        return this;
    }

    public Number getSupport() {
        return support;
    }

    public AssociationRule setSupport(
        @org.jpmml.model.annotations.Property("support")
        Number support) {
        this.support = support;
        return this;
    }

    public Number getConfidence() {
        return confidence;
    }

    public AssociationRule setConfidence(
        @org.jpmml.model.annotations.Property("confidence")
        Number confidence) {
        this.confidence = confidence;
        return this;
    }

    public Number getLift() {
        return lift;
    }

    public AssociationRule setLift(
        @org.jpmml.model.annotations.Property("lift")
        Number lift) {
        this.lift = lift;
        return this;
    }

    public Number getLeverage() {
        return leverage;
    }

    public AssociationRule setLeverage(
        @org.jpmml.model.annotations.Property("leverage")
        Number leverage) {
        this.leverage = leverage;
        return this;
    }

    public Number getAffinity() {
        return affinity;
    }

    public AssociationRule setAffinity(
        @org.jpmml.model.annotations.Property("affinity")
        Number affinity) {
        this.affinity = affinity;
        return this;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public AssociationRule setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public AssociationRule addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
