
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Property;

@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonPropertyOrder({
    "description",
    "gamma",
    "coef0",
    "degree",
    "extensions"
})
public class PolynomialKernel
    extends Kernel
    implements HasExtensions<PolynomialKernel>
{

    @XmlAttribute(name = "description")
    @JsonProperty("description")
    private String description;
    @XmlAttribute(name = "gamma")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("gamma")
    private Number gamma;
    @XmlAttribute(name = "coef0")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("coef0")
    private Number coef0;
    @XmlAttribute(name = "degree")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("degree")
    private Number degree;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static Number DEFAULT_GAMMA = new RealNumberAdapter().unmarshal("1");
    private final static Number DEFAULT_COEF0 = new RealNumberAdapter().unmarshal("1");
    private final static Number DEFAULT_DEGREE = new RealNumberAdapter().unmarshal("1");
    private final static long serialVersionUID = 67371267L;

    public String getDescription() {
        return description;
    }

    public PolynomialKernel setDescription(
        @Property("description")
        String description) {
        this.description = description;
        return this;
    }

    public Number getGamma() {
        if (gamma == null) {
            return DEFAULT_GAMMA;
        } else {
            return gamma;
        }
    }

    public PolynomialKernel setGamma(
        @Property("gamma")
        Number gamma) {
        this.gamma = gamma;
        return this;
    }

    public Number getCoef0() {
        if (coef0 == null) {
            return DEFAULT_COEF0;
        } else {
            return coef0;
        }
    }

    public PolynomialKernel setCoef0(
        @Property("coef0")
        Number coef0) {
        this.coef0 = coef0;
        return this;
    }

    public Number getDegree() {
        if (degree == null) {
            return DEFAULT_DEGREE;
        } else {
            return degree;
        }
    }

    public PolynomialKernel setDegree(
        @Property("degree")
        Number degree) {
        this.degree = degree;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public PolynomialKernel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
