
package org.dmg.pmml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasId;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "TextDocument", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("TextDocument")
@JsonPropertyOrder({
    "id",
    "name",
    "length",
    "file",
    "extensions"
})
public class TextDocument
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TextDocument> , HasId<TextDocument, String> , Indexable<String>
{

    @XmlAttribute(name = "id", required = true)
    @JsonProperty("id")
    private String id;
    @XmlAttribute(name = "name")
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "length")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("length")
    private Integer length;
    @XmlAttribute(name = "file")
    @JsonProperty("file")
    private String file;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371267L;

    public TextDocument() {
    }

    @ValueConstructor
    public TextDocument(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
    }

    @Override
    public String getKey() {
        return getId();
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public TextDocument setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public TextDocument setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public Integer getLength() {
        return length;
    }

    public TextDocument setLength(
        @org.jpmml.model.annotations.Property("length")
        Integer length) {
        this.length = length;
        return this;
    }

    public String getFile() {
        return file;
    }

    public TextDocument setFile(
        @org.jpmml.model.annotations.Property("file")
        String file) {
        this.file = file;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TextDocument addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
