/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.clustering;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Array;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Partition;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.clustering.Covariances;
import org.dmg.pmml.clustering.KohonenMap;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Cluster", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "kohonenMap", "array", "partition", "covariances"})
@JsonRootName(value="Cluster")
@JsonPropertyOrder(value={"id", "name", "size", "extensions", "kohonenMap", "array", "partition", "covariances"})
public class Cluster
extends Entity<String>
implements HasExtensions<Cluster> {
    @XmlAttribute(name="id")
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="id")
    private String id;
    @XmlAttribute(name="name")
    @JsonProperty(value="name")
    private String name;
    @XmlAttribute(name="size")
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="size")
    private Integer size;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="KohonenMap", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="KohonenMap")
    private KohonenMap kohonenMap;
    @XmlElement(name="Array", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Array")
    private Array array;
    @XmlElement(name="Partition", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Partition")
    private Partition partition;
    @XmlElement(name="Covariances", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Covariances")
    private Covariances covariances;
    private static final long serialVersionUID = 67371267L;

    public Cluster() {
    }

    @ValueConstructor
    public Cluster(@Property(value="array") Array array) {
        this.array = array;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Cluster setId(@Property(value="id") String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Cluster setName(@Property(value="name") String name) {
        this.name = name;
        return this;
    }

    public Integer getSize() {
        return this.size;
    }

    public Cluster setSize(@Property(value="size") Integer size) {
        this.size = size;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Cluster addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public KohonenMap getKohonenMap() {
        return this.kohonenMap;
    }

    public Cluster setKohonenMap(@Property(value="kohonenMap") KohonenMap kohonenMap) {
        this.kohonenMap = kohonenMap;
        return this;
    }

    public Array getArray() {
        return this.array;
    }

    public Cluster setArray(@Property(value="array") Array array) {
        this.array = array;
        return this;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public Cluster setPartition(@Property(value="partition") Partition partition) {
        this.partition = partition;
        return this;
    }

    public Covariances getCovariances() {
        return this.covariances;
    }

    public Cluster setCovariances(@Property(value="covariances") Covariances covariances) {
        this.covariances = covariances;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getKohonenMap(), this.getArray(), this.getPartition(), this.getCovariances());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

