/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.support_vector_machine;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.support_vector_machine.VectorFields;
import org.dmg.pmml.support_vector_machine.VectorInstance;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="VectorDictionary", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "vectorFields", "vectorInstances"})
@JsonRootName(value="VectorDictionary")
@JsonPropertyOrder(value={"numberOfVectors", "extensions", "vectorFields", "vectorInstances"})
public class VectorDictionary
extends PMMLObject
implements HasExtensions<VectorDictionary> {
    @XmlAttribute(name="numberOfVectors")
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="numberOfVectors")
    private Integer numberOfVectors;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="VectorFields", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @Added(value=Version.PMML_3_1)
    @JsonProperty(value="VectorFields")
    private VectorFields vectorFields;
    @XmlElement(name="VectorInstance", namespace="http://www.dmg.org/PMML-4_4")
    @Optional(value=Version.PMML_3_1)
    @JsonProperty(value="VectorInstance")
    private List<VectorInstance> vectorInstances;
    private static final long serialVersionUID = 67371267L;

    public VectorDictionary() {
    }

    @ValueConstructor
    public VectorDictionary(@Property(value="vectorFields") VectorFields vectorFields) {
        this.vectorFields = vectorFields;
    }

    public Integer getNumberOfVectors() {
        return this.numberOfVectors;
    }

    public VectorDictionary setNumberOfVectors(@Property(value="numberOfVectors") Integer numberOfVectors) {
        this.numberOfVectors = numberOfVectors;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public VectorDictionary addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public VectorFields getVectorFields() {
        return this.vectorFields;
    }

    public VectorDictionary setVectorFields(@Property(value="vectorFields") VectorFields vectorFields) {
        this.vectorFields = vectorFields;
        return this;
    }

    public boolean hasVectorInstances() {
        return this.vectorInstances != null && this.vectorInstances.size() > 0;
    }

    public List<VectorInstance> getVectorInstances() {
        if (this.vectorInstances == null) {
            this.vectorInstances = new ArrayList<VectorInstance>();
        }
        return this.vectorInstances;
    }

    public VectorDictionary addVectorInstances(VectorInstance ... vectorInstances) {
        this.getVectorInstances().addAll(Arrays.asList(vectorInstances));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getVectorFields());
            }
            if (status == VisitorAction.CONTINUE && this.hasVectorInstances()) {
                status = PMMLObject.traverse(visitor, this.getVectorInstances());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

