
package org.dmg.pmml.rule_set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "RuleSelectionMethod", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("RuleSelectionMethod")
@JsonPropertyOrder({
    "criterion",
    "extensions"
})
public class RuleSelectionMethod
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<RuleSelectionMethod>
{

    @XmlAttribute(name = "criterion", required = true)
    @JsonProperty("criterion")
    private RuleSelectionMethod.Criterion criterion;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371268L;

    public RuleSelectionMethod() {
    }

    @ValueConstructor
    public RuleSelectionMethod(
        @org.jpmml.model.annotations.Property("criterion")
        RuleSelectionMethod.Criterion criterion) {
        this.criterion = criterion;
    }

    public RuleSelectionMethod.Criterion getCriterion() {
        return criterion;
    }

    public RuleSelectionMethod setCriterion(
        @org.jpmml.model.annotations.Property("criterion")
        RuleSelectionMethod.Criterion criterion) {
        this.criterion = criterion;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public RuleSelectionMethod addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Criterion
        implements StringValue<RuleSelectionMethod.Criterion>
    {

        @XmlEnumValue("weightedSum")
        @JsonProperty("weightedSum")
        WEIGHTED_SUM("weightedSum"),
        @XmlEnumValue("weightedMax")
        @JsonProperty("weightedMax")
        WEIGHTED_MAX("weightedMax"),
        @XmlEnumValue("firstHit")
        @JsonProperty("firstHit")
        FIRST_HIT("firstHit");
        private final String value;

        Criterion(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static RuleSelectionMethod.Criterion fromValue(String v) {
            for (RuleSelectionMethod.Criterion c: RuleSelectionMethod.Criterion.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
