
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "row", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "content"
})
@JsonRootName("row")
@JsonPropertyOrder({
    "content"
})
public class Row
    extends org.dmg.pmml.PMMLObject
    implements HasMixedContent<Row>
{

    @XmlMixed
    @XmlAnyElement(lax = true)
    @JsonProperty("content")
    private List<Object> content;
    private final static long serialVersionUID = 67371268L;

    public Row() {
    }

    @ValueConstructor
    public Row(
        @Property("content")
        List<Object> content) {
        this.content = content;
    }

    public boolean hasContent() {
        return ((this.content!= null)&&(this.content.size()> 0));
    }

    @Override
    public List<Object> getContent() {
        if (content == null) {
            content = new ArrayList<Object>();
        }
        return this.content;
    }

    @Override
    public Row addContent(Object... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = org.dmg.pmml.PMMLObject.traverseMixed(visitor, getContent());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
