
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Matrix", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "arrays",
    "matCells"
})
@JsonRootName("Matrix")
@JsonPropertyOrder({
    "kind",
    "nbRows",
    "nbCols",
    "diagDefault",
    "offDiagDefault",
    "arrays",
    "matCells"
})
public class Matrix
    extends org.dmg.pmml.PMMLObject
{

    @XmlAttribute(name = "kind")
    @JsonProperty("kind")
    private Matrix.Kind kind;
    @XmlAttribute(name = "nbRows")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("nbRows")
    private Integer nbRows;
    @XmlAttribute(name = "nbCols")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("nbCols")
    private Integer nbCols;
    @XmlAttribute(name = "diagDefault")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("diagDefault")
    private Number diagDefault;
    @XmlAttribute(name = "offDiagDefault")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("offDiagDefault")
    private Number offDiagDefault;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Array")
    private List<Array> arrays;
    @XmlElement(name = "MatCell", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("MatCell")
    private List<MatCell> matCells;
    private final static long serialVersionUID = 67371011L;

    public Matrix() {
    }

    @ValueConstructor
    public Matrix(
        @org.jpmml.model.annotations.Property("arrays")
        List<Array> arrays,
        @org.jpmml.model.annotations.Property("matCells")
        List<MatCell> matCells) {
        this.arrays = arrays;
        this.matCells = matCells;
    }

    public Matrix.Kind getKind() {
        if (kind == null) {
            return Matrix.Kind.ANY;
        } else {
            return kind;
        }
    }

    public Matrix setKind(
        @org.jpmml.model.annotations.Property("kind")
        Matrix.Kind kind) {
        this.kind = kind;
        return this;
    }

    public Integer getNbRows() {
        return nbRows;
    }

    public Matrix setNbRows(
        @org.jpmml.model.annotations.Property("nbRows")
        Integer nbRows) {
        this.nbRows = nbRows;
        return this;
    }

    public Integer getNbCols() {
        return nbCols;
    }

    public Matrix setNbCols(
        @org.jpmml.model.annotations.Property("nbCols")
        Integer nbCols) {
        this.nbCols = nbCols;
        return this;
    }

    public Number getDiagDefault() {
        return diagDefault;
    }

    public Matrix setDiagDefault(
        @org.jpmml.model.annotations.Property("diagDefault")
        Number diagDefault) {
        this.diagDefault = diagDefault;
        return this;
    }

    public Number getOffDiagDefault() {
        return offDiagDefault;
    }

    public Matrix setOffDiagDefault(
        @org.jpmml.model.annotations.Property("offDiagDefault")
        Number offDiagDefault) {
        this.offDiagDefault = offDiagDefault;
        return this;
    }

    public boolean hasArrays() {
        return ((this.arrays!= null)&&(this.arrays.size()> 0));
    }

    public List<Array> getArrays() {
        if (arrays == null) {
            arrays = new ArrayList<Array>();
        }
        return this.arrays;
    }

    public Matrix addArrays(Array... arrays) {
        getArrays().addAll(Arrays.asList(arrays));
        return this;
    }

    public boolean hasMatCells() {
        return ((this.matCells!= null)&&(this.matCells.size()> 0));
    }

    public List<MatCell> getMatCells() {
        if (matCells == null) {
            matCells = new ArrayList<MatCell>();
        }
        return this.matCells;
    }

    public Matrix addMatCells(MatCell... matCells) {
        getMatCells().addAll(Arrays.asList(matCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasArrays()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArrays());
            }
            if ((status == VisitorAction.CONTINUE)&&hasMatCells()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getMatCells());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Kind
        implements StringValue<Matrix.Kind>
    {

        @XmlEnumValue("diagonal")
        @JsonProperty("diagonal")
        DIAGONAL("diagonal"),
        @XmlEnumValue("symmetric")
        @JsonProperty("symmetric")
        SYMMETRIC("symmetric"),
        @XmlEnumValue("any")
        @JsonProperty("any")
        ANY("any");
        private final String value;

        Kind(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Matrix.Kind fromValue(String v) {
            for (Matrix.Kind c: Matrix.Kind.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
