
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Predictor", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "categories",
    "matrix"
})
@JsonRootName("Predictor")
@JsonPropertyOrder({
    "field",
    "contrastMatrixType",
    "extensions",
    "categories",
    "matrix"
})
public class Predictor
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Predictor> , HasFieldReference<Predictor>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("name")
    private FieldName field;
    @XmlAttribute(name = "contrastMatrixType")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("contrastMatrixType")
    private String contrastMatrixType;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Categories", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("Categories")
    private Categories categories;
    @XmlElement(name = "Matrix", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("Matrix")
    private Matrix matrix;
    private final static long serialVersionUID = 67371011L;

    public Predictor() {
    }

    @ValueConstructor
    public Predictor(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
    }

    @Override
    public FieldName getField() {
        return field;
    }

    @Override
    public Predictor setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public String getContrastMatrixType() {
        return contrastMatrixType;
    }

    public Predictor setContrastMatrixType(
        @org.jpmml.model.annotations.Property("contrastMatrixType")
        String contrastMatrixType) {
        this.contrastMatrixType = contrastMatrixType;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Predictor addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Categories getCategories() {
        return categories;
    }

    public Predictor setCategories(
        @org.jpmml.model.annotations.Property("categories")
        Categories categories) {
        this.categories = categories;
        return this;
    }

    public Matrix getMatrix() {
        return matrix;
    }

    public Predictor setMatrix(
        @org.jpmml.model.annotations.Property("matrix")
        Matrix matrix) {
        this.matrix = matrix;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCategories(), getMatrix());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
