
package org.dmg.pmml.naive_bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.ContinuousDistribution;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "TargetValueStat", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "continuousDistribution"
})
@Added((org.dmg.pmml.Version.PMML_4_2))
@JsonRootName("TargetValueStat")
@JsonPropertyOrder({
    "value",
    "extensions",
    "continuousDistribution"
})
public class TargetValueStat
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TargetValueStat>
{

    @XmlAttribute(name = "value", required = true)
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    private Object value;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "AnyDistribution", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.AnyDistribution.class),
        @XmlElement(name = "GaussianDistribution", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.GaussianDistribution.class),
        @XmlElement(name = "PoissonDistribution", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.PoissonDistribution.class),
        @XmlElement(name = "UniformDistribution", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.UniformDistribution.class)
    })
    @JsonProperty("ContinuousDistribution")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "AnyDistribution", value = org.dmg.pmml.AnyDistribution.class),
        @JsonSubTypes.Type(name = "GaussianDistribution", value = org.dmg.pmml.GaussianDistribution.class),
        @JsonSubTypes.Type(name = "PoissonDistribution", value = org.dmg.pmml.PoissonDistribution.class),
        @JsonSubTypes.Type(name = "UniformDistribution", value = org.dmg.pmml.UniformDistribution.class)
    })
    private ContinuousDistribution continuousDistribution;
    private final static long serialVersionUID = 67371011L;

    public TargetValueStat() {
    }

    @ValueConstructor
    public TargetValueStat(
        @org.jpmml.model.annotations.Property("value")
        Object value,
        @org.jpmml.model.annotations.Property("continuousDistribution")
        ContinuousDistribution continuousDistribution) {
        this.value = value;
        this.continuousDistribution = continuousDistribution;
    }

    public Object getValue() {
        return value;
    }

    public TargetValueStat setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TargetValueStat addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public ContinuousDistribution getContinuousDistribution() {
        return continuousDistribution;
    }

    public TargetValueStat setContinuousDistribution(
        @org.jpmml.model.annotations.Property("continuousDistribution")
        ContinuousDistribution continuousDistribution) {
        this.continuousDistribution = continuousDistribution;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContinuousDistribution());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
