
package org.dmg.pmml.neural_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "NeuralInput", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "derivedField"
})
@JsonRootName("NeuralInput")
@JsonPropertyOrder({
    "id",
    "extensions",
    "derivedField"
})
public class NeuralInput
    extends NeuralEntity
    implements HasExtensions<NeuralInput>
{

    @XmlAttribute(name = "id", required = true)
    @JsonProperty("id")
    private String id;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "DerivedField", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("DerivedField")
    private DerivedField derivedField;
    private final static long serialVersionUID = 67371011L;

    public NeuralInput() {
    }

    @ValueConstructor
    public NeuralInput(
        @org.jpmml.model.annotations.Property("id")
        String id,
        @org.jpmml.model.annotations.Property("derivedField")
        DerivedField derivedField) {
        this.id = id;
        this.derivedField = derivedField;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public NeuralInput setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public NeuralInput addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public DerivedField getDerivedField() {
        return derivedField;
    }

    public NeuralInput setDerivedField(
        @org.jpmml.model.annotations.Property("derivedField")
        DerivedField derivedField) {
        this.derivedField = derivedField;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getDerivedField());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
