
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "predicates"
})
@JsonRootName("CompoundPredicate")
@JsonPropertyOrder({
    "booleanOperator",
    "extensions",
    "predicates"
})
public class CompoundPredicate
    extends org.dmg.pmml.Predicate
    implements HasExtensions<CompoundPredicate>
{

    @XmlAttribute(name = "booleanOperator", required = true)
    @JsonProperty("booleanOperator")
    private CompoundPredicate.BooleanOperator booleanOperator;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_4", type = CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.SimpleSetPredicate.class),
        @XmlElement(name = "True", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.True.class),
        @XmlElement(name = "False", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.False.class)
    })
    @JsonProperty("Predicate")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "SimplePredicate", value = org.dmg.pmml.SimplePredicate.class),
        @JsonSubTypes.Type(name = "CompoundPredicate", value = org.dmg.pmml.CompoundPredicate.class),
        @JsonSubTypes.Type(name = "SimpleSetPredicate", value = org.dmg.pmml.SimpleSetPredicate.class),
        @JsonSubTypes.Type(name = "True", value = org.dmg.pmml.True.class),
        @JsonSubTypes.Type(name = "False", value = org.dmg.pmml.False.class)
    })
    private List<org.dmg.pmml.Predicate> predicates;
    private final static long serialVersionUID = 67371011L;

    public CompoundPredicate() {
    }

    @ValueConstructor
    public CompoundPredicate(
        @org.jpmml.model.annotations.Property("booleanOperator")
        CompoundPredicate.BooleanOperator booleanOperator,
        @org.jpmml.model.annotations.Property("predicates")
        List<org.dmg.pmml.Predicate> predicates) {
        this.booleanOperator = booleanOperator;
        this.predicates = predicates;
    }

    public CompoundPredicate.BooleanOperator getBooleanOperator() {
        return booleanOperator;
    }

    public CompoundPredicate setBooleanOperator(
        @org.jpmml.model.annotations.Property("booleanOperator")
        CompoundPredicate.BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public CompoundPredicate addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasPredicates() {
        return ((this.predicates!= null)&&(this.predicates.size()> 0));
    }

    public List<org.dmg.pmml.Predicate> getPredicates() {
        if (predicates == null) {
            predicates = new ArrayList<org.dmg.pmml.Predicate>();
        }
        return this.predicates;
    }

    public CompoundPredicate addPredicates(org.dmg.pmml.Predicate... predicates) {
        getPredicates().addAll(Arrays.asList(predicates));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPredicates()) {
                status = PMMLObject.traverse(visitor, getPredicates());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum BooleanOperator
        implements StringValue<CompoundPredicate.BooleanOperator>
    {

        @XmlEnumValue("or")
        @JsonProperty("or")
        OR("or"),
        @XmlEnumValue("and")
        @JsonProperty("and")
        AND("and"),
        @XmlEnumValue("xor")
        @JsonProperty("xor")
        XOR("xor"),
        @XmlEnumValue("surrogate")
        @JsonProperty("surrogate")
        SURROGATE("surrogate");
        private final String value;

        BooleanOperator(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static CompoundPredicate.BooleanOperator fromValue(String v) {
            for (CompoundPredicate.BooleanOperator c: CompoundPredicate.BooleanOperator.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
