
package org.dmg.pmml.gaussian_process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "RadialBasisKernel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_3))
@JsonRootName("RadialBasisKernel")
@JsonPropertyOrder({
    "description",
    "gamma",
    "noiseVariance",
    "lambda",
    "extensions"
})
public class RadialBasisKernel
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<RadialBasisKernel>
{

    @XmlAttribute(name = "description")
    @JsonProperty("description")
    private String description;
    @XmlAttribute(name = "gamma")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("gamma")
    private Number gamma;
    @XmlAttribute(name = "noiseVariance")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("noiseVariance")
    private Number noiseVariance;
    @XmlAttribute(name = "lambda")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("lambda")
    private Number lambda;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static Number DEFAULT_GAMMA = new RealNumberAdapter().unmarshal("1");
    private final static Number DEFAULT_NOISE_VARIANCE = new RealNumberAdapter().unmarshal("1");
    private final static Number DEFAULT_LAMBDA = new RealNumberAdapter().unmarshal("1");
    private final static long serialVersionUID = 67371011L;

    public String getDescription() {
        return description;
    }

    public RadialBasisKernel setDescription(
        @Property("description")
        String description) {
        this.description = description;
        return this;
    }

    public Number getGamma() {
        if (gamma == null) {
            return DEFAULT_GAMMA;
        } else {
            return gamma;
        }
    }

    public RadialBasisKernel setGamma(
        @Property("gamma")
        Number gamma) {
        this.gamma = gamma;
        return this;
    }

    public Number getNoiseVariance() {
        if (noiseVariance == null) {
            return DEFAULT_NOISE_VARIANCE;
        } else {
            return noiseVariance;
        }
    }

    public RadialBasisKernel setNoiseVariance(
        @Property("noiseVariance")
        Number noiseVariance) {
        this.noiseVariance = noiseVariance;
        return this;
    }

    public Number getLambda() {
        if (lambda == null) {
            return DEFAULT_LAMBDA;
        } else {
            return lambda;
        }
    }

    public RadialBasisKernel setLambda(
        @Property("lambda")
        Number lambda) {
        this.lambda = lambda;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public RadialBasisKernel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
