
package org.dmg.pmml.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "PredictorTerm", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "fieldRefs"
})
@JsonRootName("PredictorTerm")
@JsonPropertyOrder({
    "name",
    "coefficient",
    "extensions",
    "fieldRefs"
})
public class PredictorTerm
    extends Term
    implements HasExtensions<PredictorTerm>
{

    @XmlAttribute(name = "name")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("name")
    private FieldName name;
    @XmlAttribute(name = "coefficient", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("coefficient")
    private Number coefficient;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("FieldRef")
    private List<FieldRef> fieldRefs;
    private final static long serialVersionUID = 67371011L;

    public PredictorTerm() {
    }

    @ValueConstructor
    public PredictorTerm(
        @org.jpmml.model.annotations.Property("coefficient")
        Number coefficient,
        @org.jpmml.model.annotations.Property("fieldRefs")
        List<FieldRef> fieldRefs) {
        this.coefficient = coefficient;
        this.fieldRefs = fieldRefs;
    }

    @Override
    public FieldName getName() {
        return name;
    }

    @Override
    public PredictorTerm setName(
        @org.jpmml.model.annotations.Property("name")
        FieldName name) {
        this.name = name;
        return this;
    }

    public Number getCoefficient() {
        return coefficient;
    }

    public PredictorTerm setCoefficient(
        @org.jpmml.model.annotations.Property("coefficient")
        Number coefficient) {
        this.coefficient = coefficient;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public PredictorTerm addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldRefs() {
        return ((this.fieldRefs!= null)&&(this.fieldRefs.size()> 0));
    }

    public List<FieldRef> getFieldRefs() {
        if (fieldRefs == null) {
            fieldRefs = new ArrayList<FieldRef>();
        }
        return this.fieldRefs;
    }

    public PredictorTerm addFieldRefs(FieldRef... fieldRefs) {
        getFieldRefs().addAll(Arrays.asList(fieldRefs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldRefs()) {
                status = PMMLObject.traverse(visitor, getFieldRefs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
