
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "SequenceRule", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "content"
})
@JsonRootName("SequenceRule")
@JsonPropertyOrder({
    "id",
    "numberOfSets",
    "occurrence",
    "support",
    "confidence",
    "lift",
    "content"
})
public class SequenceRule
    extends Entity<String>
{

    @XmlAttribute(name = "id", required = true)
    @JsonProperty("id")
    private String id;
    @XmlAttribute(name = "numberOfSets", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfSets")
    private Integer numberOfSets;
    @XmlAttribute(name = "occurrence", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("occurrence")
    private Integer occurrence;
    @XmlAttribute(name = "support", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("support")
    private Number support;
    @XmlAttribute(name = "confidence", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("confidence")
    private Number confidence;
    @XmlAttribute(name = "lift")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("lift")
    private Number lift;
    @XmlElementRefs({
        @XmlElementRef(name = "Delimiter", namespace = "http://www.dmg.org/PMML-4_4", type = Delimiter.class, required = false),
        @XmlElementRef(name = "ConsequentSequence", namespace = "http://www.dmg.org/PMML-4_4", type = ConsequentSequence.class, required = false),
        @XmlElementRef(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4", type = Extension.class, required = false),
        @XmlElementRef(name = "Time", namespace = "http://www.dmg.org/PMML-4_4", type = Time.class, required = false),
        @XmlElementRef(name = "AntecedentSequence", namespace = "http://www.dmg.org/PMML-4_4", type = AntecedentSequence.class, required = false)
    })
    @XmlAnyElement(lax = true)
    @JsonProperty("content")
    private List<Object> content;
    private final static long serialVersionUID = 67371011L;

    public SequenceRule() {
    }

    @ValueConstructor
    public SequenceRule(
        @org.jpmml.model.annotations.Property("id")
        String id,
        @org.jpmml.model.annotations.Property("numberOfSets")
        Integer numberOfSets,
        @org.jpmml.model.annotations.Property("occurrence")
        Integer occurrence,
        @org.jpmml.model.annotations.Property("support")
        Number support,
        @org.jpmml.model.annotations.Property("confidence")
        Number confidence) {
        this.id = id;
        this.numberOfSets = numberOfSets;
        this.occurrence = occurrence;
        this.support = support;
        this.confidence = confidence;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public SequenceRule setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public Integer getNumberOfSets() {
        return numberOfSets;
    }

    public SequenceRule setNumberOfSets(
        @org.jpmml.model.annotations.Property("numberOfSets")
        Integer numberOfSets) {
        this.numberOfSets = numberOfSets;
        return this;
    }

    public Integer getOccurrence() {
        return occurrence;
    }

    public SequenceRule setOccurrence(
        @org.jpmml.model.annotations.Property("occurrence")
        Integer occurrence) {
        this.occurrence = occurrence;
        return this;
    }

    public Number getSupport() {
        return support;
    }

    public SequenceRule setSupport(
        @org.jpmml.model.annotations.Property("support")
        Number support) {
        this.support = support;
        return this;
    }

    public Number getConfidence() {
        return confidence;
    }

    public SequenceRule setConfidence(
        @org.jpmml.model.annotations.Property("confidence")
        Number confidence) {
        this.confidence = confidence;
        return this;
    }

    public Number getLift() {
        return lift;
    }

    public SequenceRule setLift(
        @org.jpmml.model.annotations.Property("lift")
        Number lift) {
        this.lift = lift;
        return this;
    }

    public boolean hasContent() {
        return ((this.content!= null)&&(this.content.size()> 0));
    }

    public List<Object> getContent() {
        if (content == null) {
            content = new ArrayList<Object>();
        }
        return this.content;
    }

    public SequenceRule addContent(Object... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = PMMLObject.traverseMixed(visitor, getContent());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
