/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.clustering;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.clustering.CenterFields;
import org.dmg.pmml.clustering.Cluster;
import org.dmg.pmml.clustering.ClusteringField;
import org.dmg.pmml.clustering.MissingValueWeights;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.Removed;
import org.jpmml.model.annotations.Required;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="ClusteringModel", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "localTransformations", "comparisonMeasure", "clusteringFields", "centerFields", "missingValueWeights", "clusters", "modelVerification"})
@JsonRootName(value="ClusteringModel")
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "modelClass", "numberOfClusters", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "modelExplanation", "localTransformations", "comparisonMeasure", "clusteringFields", "centerFields", "missingValueWeights", "clusters", "modelVerification"})
public class ClusteringModel
extends Model
implements HasExtensions<ClusteringModel> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="modelClass", required=true)
    @JsonProperty(value="modelClass")
    private ModelClass modelClass;
    @XmlAttribute(name="numberOfClusters", required=true)
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="numberOfClusters")
    private Integer numberOfClusters;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="isScorable")
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @Added(value=Version.XPMML)
    @JsonProperty(value="x-mathContext")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_4")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="ComparisonMeasure", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="ComparisonMeasure")
    private ComparisonMeasure comparisonMeasure;
    @XmlElement(name="ClusteringField", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @Required(value=Version.PMML_4_2)
    @JsonProperty(value="ClusteringField")
    private List<ClusteringField> clusteringFields;
    @XmlElement(name="CenterFields", namespace="http://www.dmg.org/PMML-4_4")
    @Removed(value=Version.PMML_3_2)
    @JsonProperty(value="CenterFields")
    private CenterFields centerFields;
    @XmlElement(name="MissingValueWeights", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="MissingValueWeights")
    private MissingValueWeights missingValueWeights;
    @XmlElement(name="Cluster", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="Cluster")
    private List<Cluster> clusters;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 0x4040101L;

    public ClusteringModel() {
    }

    @ValueConstructor
    public ClusteringModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="modelClass") ModelClass modelClass, @Property(value="numberOfClusters") Integer numberOfClusters, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="comparisonMeasure") ComparisonMeasure comparisonMeasure, @Property(value="clusteringFields") List<ClusteringField> clusteringFields, @Property(value="clusters") List<Cluster> clusters) {
        this.miningFunction = miningFunction;
        this.modelClass = modelClass;
        this.numberOfClusters = numberOfClusters;
        this.miningSchema = miningSchema;
        this.comparisonMeasure = comparisonMeasure;
        this.clusteringFields = clusteringFields;
        this.clusters = clusters;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public ClusteringModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public ClusteringModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public ClusteringModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public ModelClass getModelClass() {
        return this.modelClass;
    }

    public ClusteringModel setModelClass(@Property(value="modelClass") ModelClass modelClass) {
        this.modelClass = modelClass;
        return this;
    }

    public Integer getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public ClusteringModel setNumberOfClusters(@Property(value="numberOfClusters") Integer numberOfClusters) {
        this.numberOfClusters = numberOfClusters;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public ClusteringModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public ClusteringModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ClusteringModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public ClusteringModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public ClusteringModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public ClusteringModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public ClusteringModel setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public ClusteringModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public ComparisonMeasure getComparisonMeasure() {
        return this.comparisonMeasure;
    }

    public ClusteringModel setComparisonMeasure(@Property(value="comparisonMeasure") ComparisonMeasure comparisonMeasure) {
        this.comparisonMeasure = comparisonMeasure;
        return this;
    }

    public boolean hasClusteringFields() {
        return this.clusteringFields != null && this.clusteringFields.size() > 0;
    }

    public List<ClusteringField> getClusteringFields() {
        if (this.clusteringFields == null) {
            this.clusteringFields = new ArrayList<ClusteringField>();
        }
        return this.clusteringFields;
    }

    public ClusteringModel addClusteringFields(ClusteringField ... clusteringFields) {
        this.getClusteringFields().addAll(Arrays.asList(clusteringFields));
        return this;
    }

    public CenterFields getCenterFields() {
        return this.centerFields;
    }

    public ClusteringModel setCenterFields(@Property(value="centerFields") CenterFields centerFields) {
        this.centerFields = centerFields;
        return this;
    }

    public MissingValueWeights getMissingValueWeights() {
        return this.missingValueWeights;
    }

    public ClusteringModel setMissingValueWeights(@Property(value="missingValueWeights") MissingValueWeights missingValueWeights) {
        this.missingValueWeights = missingValueWeights;
        return this;
    }

    public boolean hasClusters() {
        return this.clusters != null && this.clusters.size() > 0;
    }

    public List<Cluster> getClusters() {
        if (this.clusters == null) {
            this.clusters = new ArrayList<Cluster>();
        }
        return this.clusters;
    }

    public ClusteringModel addClusters(Cluster ... clusters) {
        this.getClusters().addAll(Arrays.asList(clusters));
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public ClusteringModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getLocalTransformations(), this.getComparisonMeasure());
            }
            if (status == VisitorAction.CONTINUE && this.hasClusteringFields()) {
                status = PMMLObject.traverse(visitor, this.getClusteringFields());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getCenterFields(), (Visitable)this.getMissingValueWeights());
            }
            if (status == VisitorAction.CONTINUE && this.hasClusters()) {
                status = PMMLObject.traverse(visitor, this.getClusters());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ModelClass implements StringValue<ModelClass>
    {
        CENTER_BASED("centerBased"),
        DISTRIBUTION_BASED("distributionBased");

        private final String value;

        private ModelClass(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static ModelClass fromValue(String v) {
            for (ModelClass c : ModelClass.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

