
package org.dmg.pmml.neural_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "NeuralInputs", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "neuralInputs"
})
@JsonRootName("NeuralInputs")
@JsonPropertyOrder({
    "numberOfInputs",
    "extensions",
    "neuralInputs"
})
public class NeuralInputs
    extends org.dmg.pmml.PMMLObject
    implements Iterable<NeuralInput> , HasExtensions<NeuralInputs>
{

    @XmlAttribute(name = "numberOfInputs")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfInputs")
    private Integer numberOfInputs;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "NeuralInput", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("NeuralInput")
    private List<NeuralInput> neuralInputs;
    private final static long serialVersionUID = 67371265L;

    public NeuralInputs() {
    }

    @ValueConstructor
    public NeuralInputs(
        @org.jpmml.model.annotations.Property("neuralInputs")
        List<NeuralInput> neuralInputs) {
        this.neuralInputs = neuralInputs;
    }

    public Integer getNumberOfInputs() {
        return numberOfInputs;
    }

    public NeuralInputs setNumberOfInputs(
        @org.jpmml.model.annotations.Property("numberOfInputs")
        Integer numberOfInputs) {
        this.numberOfInputs = numberOfInputs;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public NeuralInputs addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<NeuralInput> iterator() {
        return getNeuralInputs().iterator();
    }

    public boolean hasNeuralInputs() {
        return ((this.neuralInputs!= null)&&(this.neuralInputs.size()> 0));
    }

    public List<NeuralInput> getNeuralInputs() {
        if (neuralInputs == null) {
            neuralInputs = new ArrayList<NeuralInput>();
        }
        return this.neuralInputs;
    }

    public NeuralInputs addNeuralInputs(NeuralInput... neuralInputs) {
        getNeuralInputs().addAll(Arrays.asList(neuralInputs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasNeuralInputs()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getNeuralInputs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
