
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("SimplePredicate")
@JsonPropertyOrder({
    "field",
    "operator",
    "value",
    "extensions"
})
public class SimplePredicate
    extends Predicate
    implements HasExtensions<SimplePredicate> , HasFieldReference<SimplePredicate> , HasValue<SimplePredicate>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private FieldName field;
    @XmlAttribute(name = "operator", required = true)
    @JsonProperty("operator")
    private SimplePredicate.Operator operator;
    @XmlAttribute(name = "value")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    private Object value;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371265L;

    public SimplePredicate() {
    }

    @ValueConstructor
    public SimplePredicate(
        @org.jpmml.model.annotations.Property("field")
        FieldName field,
        @org.jpmml.model.annotations.Property("operator")
        SimplePredicate.Operator operator,
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.field = field;
        this.operator = operator;
        this.value = value;
    }

    @Override
    public FieldName getField() {
        return field;
    }

    @Override
    public SimplePredicate setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public SimplePredicate.Operator getOperator() {
        return operator;
    }

    public SimplePredicate setOperator(
        @org.jpmml.model.annotations.Property("operator")
        SimplePredicate.Operator operator) {
        this.operator = operator;
        return this;
    }

    @Override
    public Object getValue() {
        return value;
    }

    @Override
    public SimplePredicate setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SimplePredicate addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Operator
        implements StringValue<SimplePredicate.Operator>
    {

        @XmlEnumValue("equal")
        @JsonProperty("equal")
        EQUAL("equal"),
        @XmlEnumValue("notEqual")
        @JsonProperty("notEqual")
        NOT_EQUAL("notEqual"),
        @XmlEnumValue("lessThan")
        @JsonProperty("lessThan")
        LESS_THAN("lessThan"),
        @XmlEnumValue("lessOrEqual")
        @JsonProperty("lessOrEqual")
        LESS_OR_EQUAL("lessOrEqual"),
        @XmlEnumValue("greaterThan")
        @JsonProperty("greaterThan")
        GREATER_THAN("greaterThan"),
        @XmlEnumValue("greaterOrEqual")
        @JsonProperty("greaterOrEqual")
        GREATER_OR_EQUAL("greaterOrEqual"),
        @XmlEnumValue("isMissing")
        @JsonProperty("isMissing")
        IS_MISSING("isMissing"),
        @XmlEnumValue("isNotMissing")
        @JsonProperty("isNotMissing")
        IS_NOT_MISSING("isNotMissing");
        private final String value;

        Operator(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static SimplePredicate.Operator fromValue(String v) {
            for (SimplePredicate.Operator c: SimplePredicate.Operator.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
