/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.tree;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultField;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.dmg.pmml.tree.ComplexNode;
import org.dmg.pmml.tree.Node;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Deprecated;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="DecisionTree", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "output", "modelStats", "targets", "localTransformations", "resultFields", "node"})
@Deprecated(value=Version.PMML_4_1)
@JsonRootName(value="DecisionTree")
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "missingValueStrategy", "missingValuePenalty", "noTrueChildStrategy", "splitCharacteristic", "extensions", "output", "modelStats", "targets", "localTransformations", "resultFields", "node"})
public class DecisionTree
extends EmbeddedModel
implements HasExtensions<DecisionTree> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="missingValueStrategy")
    @Added(value=Version.PMML_3_1)
    @JsonProperty(value="missingValueStrategy")
    private MissingValueStrategy missingValueStrategy;
    @XmlAttribute(name="missingValuePenalty")
    @XmlJavaTypeAdapter(value=ProbabilityNumberAdapter.class)
    @Added(value=Version.PMML_3_1)
    @JsonProperty(value="missingValuePenalty")
    private Number missingValuePenalty;
    @XmlAttribute(name="noTrueChildStrategy")
    @Added(value=Version.PMML_3_1)
    @JsonProperty(value="noTrueChildStrategy")
    private NoTrueChildStrategy noTrueChildStrategy;
    @XmlAttribute(name="splitCharacteristic")
    @JsonProperty(value="splitCharacteristic")
    private SplitCharacteristic splitCharacteristic;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_4")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_4")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_4")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="Targets")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="ResultField", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ResultField")
    private List<ResultField> resultFields;
    @XmlElement(name="Node", namespace="http://www.dmg.org/PMML-4_4", required=true, type=ComplexNode.class)
    @JsonProperty(value="Node")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="Node", value=ComplexNode.class)})
    private Node node;
    private static final Number DEFAULT_MISSING_VALUE_PENALTY = new ProbabilityNumberAdapter().unmarshal("1.0");
    private static final long serialVersionUID = 0x4040101L;

    public DecisionTree() {
    }

    @ValueConstructor
    public DecisionTree(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="node") Node node) {
        this.miningFunction = miningFunction;
        this.node = node;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public DecisionTree setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public DecisionTree setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public DecisionTree setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public MissingValueStrategy getMissingValueStrategy() {
        if (this.missingValueStrategy == null) {
            return MissingValueStrategy.NONE;
        }
        return this.missingValueStrategy;
    }

    public DecisionTree setMissingValueStrategy(@Property(value="missingValueStrategy") MissingValueStrategy missingValueStrategy) {
        this.missingValueStrategy = missingValueStrategy;
        return this;
    }

    public Number getMissingValuePenalty() {
        if (this.missingValuePenalty == null) {
            return DEFAULT_MISSING_VALUE_PENALTY;
        }
        return this.missingValuePenalty;
    }

    public DecisionTree setMissingValuePenalty(@Property(value="missingValuePenalty") Number missingValuePenalty) {
        this.missingValuePenalty = missingValuePenalty;
        return this;
    }

    public NoTrueChildStrategy getNoTrueChildStrategy() {
        if (this.noTrueChildStrategy == null) {
            return NoTrueChildStrategy.RETURN_NULL_PREDICTION;
        }
        return this.noTrueChildStrategy;
    }

    public DecisionTree setNoTrueChildStrategy(@Property(value="noTrueChildStrategy") NoTrueChildStrategy noTrueChildStrategy) {
        this.noTrueChildStrategy = noTrueChildStrategy;
        return this;
    }

    public SplitCharacteristic getSplitCharacteristic() {
        if (this.splitCharacteristic == null) {
            return SplitCharacteristic.MULTI_SPLIT;
        }
        return this.splitCharacteristic;
    }

    public DecisionTree setSplitCharacteristic(@Property(value="splitCharacteristic") SplitCharacteristic splitCharacteristic) {
        this.splitCharacteristic = splitCharacteristic;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public DecisionTree addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public DecisionTree setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public DecisionTree setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public DecisionTree setTargets(@Property(value="targets") Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public DecisionTree setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public boolean hasResultFields() {
        return this.resultFields != null && this.resultFields.size() > 0;
    }

    public List<ResultField> getResultFields() {
        if (this.resultFields == null) {
            this.resultFields = new ArrayList<ResultField>();
        }
        return this.resultFields;
    }

    public DecisionTree addResultFields(ResultField ... resultFields) {
        this.getResultFields().addAll(Arrays.asList(resultFields));
        return this;
    }

    public Node getNode() {
        return this.node;
    }

    public DecisionTree setNode(@Property(value="node") Node node) {
        this.node = node;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getOutput(), this.getModelStats(), this.getTargets(), this.getLocalTransformations());
            }
            if (status == VisitorAction.CONTINUE && this.hasResultFields()) {
                status = PMMLObject.traverse(visitor, this.getResultFields());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getNode());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum SplitCharacteristic implements StringValue<SplitCharacteristic>
    {
        BINARY_SPLIT("binarySplit"),
        MULTI_SPLIT("multiSplit");

        private final String value;

        private SplitCharacteristic(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static SplitCharacteristic fromValue(String v) {
            for (SplitCharacteristic c : SplitCharacteristic.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum NoTrueChildStrategy implements StringValue<NoTrueChildStrategy>
    {
        RETURN_NULL_PREDICTION("returnNullPrediction"),
        RETURN_LAST_PREDICTION("returnLastPrediction");

        private final String value;

        private NoTrueChildStrategy(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static NoTrueChildStrategy fromValue(String v) {
            for (NoTrueChildStrategy c : NoTrueChildStrategy.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum MissingValueStrategy implements StringValue<MissingValueStrategy>
    {
        LAST_PREDICTION("lastPrediction"),
        NULL_PREDICTION("nullPrediction"),
        DEFAULT_CHILD("defaultChild"),
        WEIGHTED_CONFIDENCE("weightedConfidence"),
        AGGREGATE_NODES("aggregateNodes"),
        NONE("none");

        private final String value;

        private MissingValueStrategy(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static MissingValueStrategy fromValue(String v) {
            for (MissingValueStrategy c : MissingValueStrategy.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

