
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Deprecated;
import org.jpmml.model.annotations.Required;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "GeneralRegressionModel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "parameterList",
    "factorList",
    "covariateList",
    "ppMatrix",
    "pCovMatrix",
    "paramMatrix",
    "eventValues",
    "baseCumHazardTables",
    "modelVerification"
})
@JsonRootName("GeneralRegressionModel")
@JsonPropertyOrder({
    "targetVariable",
    "modelType",
    "modelName",
    "miningFunction",
    "algorithmName",
    "targetReferenceCategory",
    "cumulativeLinkFunction",
    "linkFunction",
    "linkParameter",
    "trialsVariable",
    "trialsValue",
    "distribution",
    "distParameter",
    "offsetVariable",
    "offsetValue",
    "modelDF",
    "endTimeVariable",
    "startTimeVariable",
    "subjectIDVariable",
    "statusVariable",
    "baselineStrataVariable",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "parameterList",
    "factorList",
    "covariateList",
    "ppMatrix",
    "pCovMatrix",
    "paramMatrix",
    "eventValues",
    "baseCumHazardTables",
    "modelVerification"
})
public class GeneralRegressionModel
    extends Model
    implements HasExtensions<GeneralRegressionModel>
{

    @XmlAttribute(name = "targetVariableName")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Deprecated((org.dmg.pmml.Version.PMML_3_0))
    @JsonProperty("targetVariableName")
    private String targetVariable;
    @XmlAttribute(name = "modelType", required = true)
    @JsonProperty("modelType")
    private GeneralRegressionModel.ModelType modelType;
    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "targetReferenceCategory")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("targetReferenceCategory")
    private Object targetReferenceCategory;
    @XmlAttribute(name = "cumulativeLink")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("cumulativeLink")
    private GeneralRegressionModel.CumulativeLinkFunction cumulativeLinkFunction;
    @XmlAttribute(name = "linkFunction")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("linkFunction")
    private GeneralRegressionModel.LinkFunction linkFunction;
    @XmlAttribute(name = "linkParameter")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("linkParameter")
    private Number linkParameter;
    @XmlAttribute(name = "trialsVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("trialsVariable")
    private String trialsVariable;
    @XmlAttribute(name = "trialsValue")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("trialsValue")
    private Integer trialsValue;
    @XmlAttribute(name = "distribution")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("distribution")
    private GeneralRegressionModel.Distribution distribution;
    @XmlAttribute(name = "distParameter")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("distParameter")
    private Number distParameter;
    @XmlAttribute(name = "offsetVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("offsetVariable")
    private String offsetVariable;
    @XmlAttribute(name = "offsetValue")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("offsetValue")
    private Number offsetValue;
    @XmlAttribute(name = "modelDF")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("modelDF")
    private Number modelDF;
    @XmlAttribute(name = "endTimeVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("endTimeVariable")
    private String endTimeVariable;
    @XmlAttribute(name = "startTimeVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("startTimeVariable")
    private String startTimeVariable;
    @XmlAttribute(name = "subjectIDVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("subjectIDVariable")
    private String subjectIDVariable;
    @XmlAttribute(name = "statusVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("statusVariable")
    private String statusVariable;
    @XmlAttribute(name = "baselineStrataVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("baselineStrataVariable")
    private String baselineStrataVariable;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("isScorable")
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.XPMML))
    @JsonProperty("x-mathContext")
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "ParameterList", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("ParameterList")
    private ParameterList parameterList;
    @XmlElement(name = "FactorList", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("FactorList")
    private FactorList factorList;
    @XmlElement(name = "CovariateList", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("CovariateList")
    private CovariateList covariateList;
    @XmlElement(name = "PPMatrix", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @Required((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("PPMatrix")
    private PPMatrix ppMatrix;
    @XmlElement(name = "PCovMatrix", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("PCovMatrix")
    private PCovMatrix pCovMatrix;
    @XmlElement(name = "ParamMatrix", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("ParamMatrix")
    private ParamMatrix paramMatrix;
    @XmlElement(name = "EventValues", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("EventValues")
    private EventValues eventValues;
    @XmlElement(name = "BaseCumHazardTables", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("BaseCumHazardTables")
    private BaseCumHazardTables baseCumHazardTables;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67371269L;

    public GeneralRegressionModel() {
    }

    @ValueConstructor
    public GeneralRegressionModel(
        @org.jpmml.model.annotations.Property("modelType")
        GeneralRegressionModel.ModelType modelType,
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("parameterList")
        ParameterList parameterList,
        @org.jpmml.model.annotations.Property("ppMatrix")
        PPMatrix ppMatrix,
        @org.jpmml.model.annotations.Property("paramMatrix")
        ParamMatrix paramMatrix) {
        this.modelType = modelType;
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.parameterList = parameterList;
        this.ppMatrix = ppMatrix;
        this.paramMatrix = paramMatrix;
    }

    public String getTargetVariable() {
        return targetVariable;
    }

    public GeneralRegressionModel setTargetVariable(
        @org.jpmml.model.annotations.Property("targetVariable")
        String targetVariable) {
        this.targetVariable = targetVariable;
        return this;
    }

    public GeneralRegressionModel.ModelType getModelType() {
        return modelType;
    }

    public GeneralRegressionModel setModelType(
        @org.jpmml.model.annotations.Property("modelType")
        GeneralRegressionModel.ModelType modelType) {
        this.modelType = modelType;
        return this;
    }

    @Override
    public String getModelName() {
        return modelName;
    }

    @Override
    public GeneralRegressionModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    @Override
    public GeneralRegressionModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public GeneralRegressionModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Object getTargetReferenceCategory() {
        return targetReferenceCategory;
    }

    public GeneralRegressionModel setTargetReferenceCategory(
        @org.jpmml.model.annotations.Property("targetReferenceCategory")
        Object targetReferenceCategory) {
        this.targetReferenceCategory = targetReferenceCategory;
        return this;
    }

    public GeneralRegressionModel.CumulativeLinkFunction getCumulativeLinkFunction() {
        return cumulativeLinkFunction;
    }

    public GeneralRegressionModel setCumulativeLinkFunction(
        @org.jpmml.model.annotations.Property("cumulativeLinkFunction")
        GeneralRegressionModel.CumulativeLinkFunction cumulativeLinkFunction) {
        this.cumulativeLinkFunction = cumulativeLinkFunction;
        return this;
    }

    public GeneralRegressionModel.LinkFunction getLinkFunction() {
        return linkFunction;
    }

    public GeneralRegressionModel setLinkFunction(
        @org.jpmml.model.annotations.Property("linkFunction")
        GeneralRegressionModel.LinkFunction linkFunction) {
        this.linkFunction = linkFunction;
        return this;
    }

    public Number getLinkParameter() {
        return linkParameter;
    }

    public GeneralRegressionModel setLinkParameter(
        @org.jpmml.model.annotations.Property("linkParameter")
        Number linkParameter) {
        this.linkParameter = linkParameter;
        return this;
    }

    public String getTrialsVariable() {
        return trialsVariable;
    }

    public GeneralRegressionModel setTrialsVariable(
        @org.jpmml.model.annotations.Property("trialsVariable")
        String trialsVariable) {
        this.trialsVariable = trialsVariable;
        return this;
    }

    public Integer getTrialsValue() {
        return trialsValue;
    }

    public GeneralRegressionModel setTrialsValue(
        @org.jpmml.model.annotations.Property("trialsValue")
        Integer trialsValue) {
        this.trialsValue = trialsValue;
        return this;
    }

    public GeneralRegressionModel.Distribution getDistribution() {
        return distribution;
    }

    public GeneralRegressionModel setDistribution(
        @org.jpmml.model.annotations.Property("distribution")
        GeneralRegressionModel.Distribution distribution) {
        this.distribution = distribution;
        return this;
    }

    public Number getDistParameter() {
        return distParameter;
    }

    public GeneralRegressionModel setDistParameter(
        @org.jpmml.model.annotations.Property("distParameter")
        Number distParameter) {
        this.distParameter = distParameter;
        return this;
    }

    public String getOffsetVariable() {
        return offsetVariable;
    }

    public GeneralRegressionModel setOffsetVariable(
        @org.jpmml.model.annotations.Property("offsetVariable")
        String offsetVariable) {
        this.offsetVariable = offsetVariable;
        return this;
    }

    public Number getOffsetValue() {
        return offsetValue;
    }

    public GeneralRegressionModel setOffsetValue(
        @org.jpmml.model.annotations.Property("offsetValue")
        Number offsetValue) {
        this.offsetValue = offsetValue;
        return this;
    }

    public Number getModelDF() {
        return modelDF;
    }

    public GeneralRegressionModel setModelDF(
        @org.jpmml.model.annotations.Property("modelDF")
        Number modelDF) {
        this.modelDF = modelDF;
        return this;
    }

    public String getEndTimeVariable() {
        return endTimeVariable;
    }

    public GeneralRegressionModel setEndTimeVariable(
        @org.jpmml.model.annotations.Property("endTimeVariable")
        String endTimeVariable) {
        this.endTimeVariable = endTimeVariable;
        return this;
    }

    public String getStartTimeVariable() {
        return startTimeVariable;
    }

    public GeneralRegressionModel setStartTimeVariable(
        @org.jpmml.model.annotations.Property("startTimeVariable")
        String startTimeVariable) {
        this.startTimeVariable = startTimeVariable;
        return this;
    }

    public String getSubjectIDVariable() {
        return subjectIDVariable;
    }

    public GeneralRegressionModel setSubjectIDVariable(
        @org.jpmml.model.annotations.Property("subjectIDVariable")
        String subjectIDVariable) {
        this.subjectIDVariable = subjectIDVariable;
        return this;
    }

    public String getStatusVariable() {
        return statusVariable;
    }

    public GeneralRegressionModel setStatusVariable(
        @org.jpmml.model.annotations.Property("statusVariable")
        String statusVariable) {
        this.statusVariable = statusVariable;
        return this;
    }

    public String getBaselineStrataVariable() {
        return baselineStrataVariable;
    }

    public GeneralRegressionModel setBaselineStrataVariable(
        @org.jpmml.model.annotations.Property("baselineStrataVariable")
        String baselineStrataVariable) {
        this.baselineStrataVariable = baselineStrataVariable;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    @Override
    public GeneralRegressionModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    @Override
    public GeneralRegressionModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public GeneralRegressionModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    @Override
    public GeneralRegressionModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return output;
    }

    @Override
    public GeneralRegressionModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return modelStats;
    }

    @Override
    public GeneralRegressionModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    @Override
    public GeneralRegressionModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return targets;
    }

    @Override
    public GeneralRegressionModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    @Override
    public GeneralRegressionModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public ParameterList getParameterList() {
        return parameterList;
    }

    public GeneralRegressionModel setParameterList(
        @org.jpmml.model.annotations.Property("parameterList")
        ParameterList parameterList) {
        this.parameterList = parameterList;
        return this;
    }

    public FactorList getFactorList() {
        return factorList;
    }

    public GeneralRegressionModel setFactorList(
        @org.jpmml.model.annotations.Property("factorList")
        FactorList factorList) {
        this.factorList = factorList;
        return this;
    }

    public CovariateList getCovariateList() {
        return covariateList;
    }

    public GeneralRegressionModel setCovariateList(
        @org.jpmml.model.annotations.Property("covariateList")
        CovariateList covariateList) {
        this.covariateList = covariateList;
        return this;
    }

    public PPMatrix getPPMatrix() {
        return ppMatrix;
    }

    public GeneralRegressionModel setPPMatrix(
        @org.jpmml.model.annotations.Property("ppMatrix")
        PPMatrix ppMatrix) {
        this.ppMatrix = ppMatrix;
        return this;
    }

    public PCovMatrix getPCovMatrix() {
        return pCovMatrix;
    }

    public GeneralRegressionModel setPCovMatrix(
        @org.jpmml.model.annotations.Property("pCovMatrix")
        PCovMatrix pCovMatrix) {
        this.pCovMatrix = pCovMatrix;
        return this;
    }

    public ParamMatrix getParamMatrix() {
        return paramMatrix;
    }

    public GeneralRegressionModel setParamMatrix(
        @org.jpmml.model.annotations.Property("paramMatrix")
        ParamMatrix paramMatrix) {
        this.paramMatrix = paramMatrix;
        return this;
    }

    public EventValues getEventValues() {
        return eventValues;
    }

    public GeneralRegressionModel setEventValues(
        @org.jpmml.model.annotations.Property("eventValues")
        EventValues eventValues) {
        this.eventValues = eventValues;
        return this;
    }

    public BaseCumHazardTables getBaseCumHazardTables() {
        return baseCumHazardTables;
    }

    public GeneralRegressionModel setBaseCumHazardTables(
        @org.jpmml.model.annotations.Property("baseCumHazardTables")
        BaseCumHazardTables baseCumHazardTables) {
        this.baseCumHazardTables = baseCumHazardTables;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    @Override
    public GeneralRegressionModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getParameterList(), getFactorList(), getCovariateList(), getPPMatrix(), getPCovMatrix(), getParamMatrix(), getEventValues(), getBaseCumHazardTables(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum CumulativeLinkFunction
        implements StringValue<GeneralRegressionModel.CumulativeLinkFunction>
    {

        @XmlEnumValue("logit")
        @JsonProperty("logit")
        LOGIT("logit"),
        @XmlEnumValue("probit")
        @JsonProperty("probit")
        PROBIT("probit"),
        @XmlEnumValue("cloglog")
        @JsonProperty("cloglog")
        CLOGLOG("cloglog"),
        @XmlEnumValue("loglog")
        @JsonProperty("loglog")
        LOGLOG("loglog"),
        @XmlEnumValue("cauchit")
        @JsonProperty("cauchit")
        CAUCHIT("cauchit");
        private final String value;

        CumulativeLinkFunction(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static GeneralRegressionModel.CumulativeLinkFunction fromValue(String v) {
            for (GeneralRegressionModel.CumulativeLinkFunction c: GeneralRegressionModel.CumulativeLinkFunction.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum Distribution
        implements StringValue<GeneralRegressionModel.Distribution>
    {

        @XmlEnumValue("binomial")
        @JsonProperty("binomial")
        BINOMIAL("binomial"),
        @XmlEnumValue("gamma")
        @JsonProperty("gamma")
        GAMMA("gamma"),
        @XmlEnumValue("igauss")
        @JsonProperty("igauss")
        IGAUSS("igauss"),
        @XmlEnumValue("negbin")
        @JsonProperty("negbin")
        NEGBIN("negbin"),
        @XmlEnumValue("normal")
        @JsonProperty("normal")
        NORMAL("normal"),
        @XmlEnumValue("poisson")
        @JsonProperty("poisson")
        POISSON("poisson"),
        @XmlEnumValue("tweedie")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
        @JsonProperty("tweedie")
        TWEEDIE("tweedie");
        private final String value;

        Distribution(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static GeneralRegressionModel.Distribution fromValue(String v) {
            for (GeneralRegressionModel.Distribution c: GeneralRegressionModel.Distribution.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum LinkFunction
        implements StringValue<GeneralRegressionModel.LinkFunction>
    {

        @XmlEnumValue("cloglog")
        @JsonProperty("cloglog")
        CLOGLOG("cloglog"),
        @XmlEnumValue("identity")
        @JsonProperty("identity")
        IDENTITY("identity"),
        @XmlEnumValue("log")
        @JsonProperty("log")
        LOG("log"),
        @XmlEnumValue("logc")
        @JsonProperty("logc")
        LOGC("logc"),
        @XmlEnumValue("logit")
        @JsonProperty("logit")
        LOGIT("logit"),
        @XmlEnumValue("loglog")
        @JsonProperty("loglog")
        LOGLOG("loglog"),
        @XmlEnumValue("negbin")
        @JsonProperty("negbin")
        NEGBIN("negbin"),
        @XmlEnumValue("oddspower")
        @JsonProperty("oddspower")
        ODDSPOWER("oddspower"),
        @XmlEnumValue("power")
        @JsonProperty("power")
        POWER("power"),
        @XmlEnumValue("probit")
        @JsonProperty("probit")
        PROBIT("probit");
        private final String value;

        LinkFunction(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static GeneralRegressionModel.LinkFunction fromValue(String v) {
            for (GeneralRegressionModel.LinkFunction c: GeneralRegressionModel.LinkFunction.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum ModelType
        implements StringValue<GeneralRegressionModel.ModelType>
    {

        @XmlEnumValue("regression")
        @JsonProperty("regression")
        REGRESSION("regression"),
        @XmlEnumValue("generalLinear")
        @JsonProperty("generalLinear")
        GENERAL_LINEAR("generalLinear"),
        @XmlEnumValue("multinomialLogistic")
        @JsonProperty("multinomialLogistic")
        MULTINOMIAL_LOGISTIC("multinomialLogistic"),
        @XmlEnumValue("ordinalMultinomial")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
        @JsonProperty("ordinalMultinomial")
        ORDINAL_MULTINOMIAL("ordinalMultinomial"),
        @XmlEnumValue("generalizedLinear")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
        @JsonProperty("generalizedLinear")
        GENERALIZED_LINEAR("generalizedLinear"),
        @XmlEnumValue("CoxRegression")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
        @JsonProperty("CoxRegression")
        COX_REGRESSION("CoxRegression");
        private final String value;

        ModelType(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static GeneralRegressionModel.ModelType fromValue(String v) {
            for (GeneralRegressionModel.ModelType c: GeneralRegressionModel.ModelType.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
