
package org.dmg.pmml.naive_bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "BayesInput", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "targetValueStats",
    "derivedField",
    "pairCounts"
})
@JsonRootName("BayesInput")
@JsonPropertyOrder({
    "field",
    "extensions",
    "targetValueStats",
    "derivedField",
    "pairCounts"
})
public class BayesInput
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<BayesInput> , HasFieldReference<BayesInput>
{

    @XmlAttribute(name = "fieldName", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("fieldName")
    private String field;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "TargetValueStats", namespace = "http://www.dmg.org/PMML-4_4")
    @Added((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("TargetValueStats")
    private TargetValueStats targetValueStats;
    @XmlElement(name = "DerivedField", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("DerivedField")
    private DerivedField derivedField;
    @XmlElement(name = "PairCounts", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("PairCounts")
    private List<PairCounts> pairCounts;
    private final static long serialVersionUID = 67371269L;

    public BayesInput() {
    }

    @ValueConstructor
    public BayesInput(
        @org.jpmml.model.annotations.Property("field")
        String field,
        @org.jpmml.model.annotations.Property("targetValueStats")
        TargetValueStats targetValueStats,
        @org.jpmml.model.annotations.Property("pairCounts")
        List<PairCounts> pairCounts) {
        this.field = field;
        this.targetValueStats = targetValueStats;
        this.pairCounts = pairCounts;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public BayesInput setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public BayesInput addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public TargetValueStats getTargetValueStats() {
        return targetValueStats;
    }

    public BayesInput setTargetValueStats(
        @org.jpmml.model.annotations.Property("targetValueStats")
        TargetValueStats targetValueStats) {
        this.targetValueStats = targetValueStats;
        return this;
    }

    public DerivedField getDerivedField() {
        return derivedField;
    }

    public BayesInput setDerivedField(
        @org.jpmml.model.annotations.Property("derivedField")
        DerivedField derivedField) {
        this.derivedField = derivedField;
        return this;
    }

    public boolean hasPairCounts() {
        return ((this.pairCounts!= null)&&(this.pairCounts.size()> 0));
    }

    public List<PairCounts> getPairCounts() {
        if (pairCounts == null) {
            pairCounts = new ArrayList<PairCounts>();
        }
        return this.pairCounts;
    }

    public BayesInput addPairCounts(PairCounts... pairCounts) {
        getPairCounts().addAll(Arrays.asList(pairCounts));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTargetValueStats(), getDerivedField());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPairCounts()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPairCounts());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
