/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.ModelLiftGraph;
import org.dmg.pmml.OptimumLiftGraph;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.RandomLiftGraph;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="LiftData", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "modelLiftGraph", "optimumLiftGraph", "randomLiftGraph"})
@Added(value=Version.PMML_4_0)
@JsonRootName(value="LiftData")
@JsonPropertyOrder(value={"targetFieldValue", "targetFieldDisplayValue", "rankingQuality", "extensions", "modelLiftGraph", "optimumLiftGraph", "randomLiftGraph"})
public class LiftData
extends PMMLObject
implements HasExtensions<LiftData> {
    @XmlAttribute(name="targetFieldValue")
    @JsonProperty(value="targetFieldValue")
    private String targetFieldValue;
    @XmlAttribute(name="targetFieldDisplayValue")
    @JsonProperty(value="targetFieldDisplayValue")
    private String targetFieldDisplayValue;
    @XmlAttribute(name="rankingQuality")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="rankingQuality")
    private Number rankingQuality;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="ModelLiftGraph", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="ModelLiftGraph")
    private ModelLiftGraph modelLiftGraph;
    @XmlElement(name="OptimumLiftGraph", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="OptimumLiftGraph")
    private OptimumLiftGraph optimumLiftGraph;
    @XmlElement(name="RandomLiftGraph", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="RandomLiftGraph")
    private RandomLiftGraph randomLiftGraph;
    private static final long serialVersionUID = 67371269L;

    public LiftData() {
    }

    @ValueConstructor
    public LiftData(@Property(value="modelLiftGraph") ModelLiftGraph modelLiftGraph) {
        this.modelLiftGraph = modelLiftGraph;
    }

    public String getTargetFieldValue() {
        return this.targetFieldValue;
    }

    public LiftData setTargetFieldValue(@Property(value="targetFieldValue") String targetFieldValue) {
        this.targetFieldValue = targetFieldValue;
        return this;
    }

    public String getTargetFieldDisplayValue() {
        return this.targetFieldDisplayValue;
    }

    public LiftData setTargetFieldDisplayValue(@Property(value="targetFieldDisplayValue") String targetFieldDisplayValue) {
        this.targetFieldDisplayValue = targetFieldDisplayValue;
        return this;
    }

    public Number getRankingQuality() {
        return this.rankingQuality;
    }

    public LiftData setRankingQuality(@Property(value="rankingQuality") Number rankingQuality) {
        this.rankingQuality = rankingQuality;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public LiftData addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public ModelLiftGraph getModelLiftGraph() {
        return this.modelLiftGraph;
    }

    public LiftData setModelLiftGraph(@Property(value="modelLiftGraph") ModelLiftGraph modelLiftGraph) {
        this.modelLiftGraph = modelLiftGraph;
        return this;
    }

    public OptimumLiftGraph getOptimumLiftGraph() {
        return this.optimumLiftGraph;
    }

    public LiftData setOptimumLiftGraph(@Property(value="optimumLiftGraph") OptimumLiftGraph optimumLiftGraph) {
        this.optimumLiftGraph = optimumLiftGraph;
        return this;
    }

    public RandomLiftGraph getRandomLiftGraph() {
        return this.randomLiftGraph;
    }

    public LiftData setRandomLiftGraph(@Property(value="randomLiftGraph") RandomLiftGraph randomLiftGraph) {
        this.randomLiftGraph = randomLiftGraph;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getModelLiftGraph(), this.getOptimumLiftGraph(), this.getRandomLiftGraph());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

