/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.PartitionFieldStats;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Partition", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "partitionFieldStats"})
@JsonRootName(value="Partition")
@JsonPropertyOrder(value={"name", "size", "extensions", "partitionFieldStats"})
public class Partition
extends PMMLObject
implements HasExtensions<Partition> {
    @XmlAttribute(name="name", required=true)
    @JsonProperty(value="name")
    private String name;
    @XmlAttribute(name="size")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="size")
    private Number size;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="PartitionFieldStats", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="PartitionFieldStats")
    private List<PartitionFieldStats> partitionFieldStats;
    private static final long serialVersionUID = 67371269L;

    public Partition() {
    }

    @ValueConstructor
    public Partition(@Property(value="name") String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Partition setName(@Property(value="name") String name) {
        this.name = name;
        return this;
    }

    public Number getSize() {
        return this.size;
    }

    public Partition setSize(@Property(value="size") Number size) {
        this.size = size;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Partition addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasPartitionFieldStats() {
        return this.partitionFieldStats != null && this.partitionFieldStats.size() > 0;
    }

    public List<PartitionFieldStats> getPartitionFieldStats() {
        if (this.partitionFieldStats == null) {
            this.partitionFieldStats = new ArrayList<PartitionFieldStats>();
        }
        return this.partitionFieldStats;
    }

    public Partition addPartitionFieldStats(PartitionFieldStats ... partitionFieldStats) {
        this.getPartitionFieldStats().addAll(Arrays.asList(partitionFieldStats));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasPartitionFieldStats()) {
                status = PMMLObject.traverse(visitor, this.getPartitionFieldStats());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

