/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasRecordCount;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="ScoreDistribution", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="ScoreDistribution")
@JsonPropertyOrder(value={"value", "recordCount", "confidence", "probability", "extensions"})
public class ScoreDistribution
extends PMMLObject
implements HasExtensions<ScoreDistribution>,
HasRecordCount<ScoreDistribution> {
    @XmlAttribute(name="value", required=true)
    @XmlJavaTypeAdapter(value=ObjectAdapter.class)
    @XmlSchemaType(name="anySimpleType")
    @JsonProperty(value="value")
    private Object value;
    @XmlAttribute(name="recordCount", required=true)
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="recordCount")
    private Number recordCount;
    @XmlAttribute(name="confidence")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @Added(value=Version.PMML_3_1)
    @JsonProperty(value="confidence")
    private Number confidence;
    @XmlAttribute(name="probability")
    @XmlJavaTypeAdapter(value=ProbabilityNumberAdapter.class)
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="probability")
    private Number probability;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371269L;

    public ScoreDistribution() {
    }

    @ValueConstructor
    public ScoreDistribution(@Property(value="value") Object value, @Property(value="recordCount") Number recordCount) {
        this.value = value;
        this.recordCount = recordCount;
    }

    public Object getValue() {
        return this.value;
    }

    public ScoreDistribution setValue(@Property(value="value") Object value) {
        this.value = value;
        return this;
    }

    @Override
    public Number getRecordCount() {
        return this.recordCount;
    }

    @Override
    public ScoreDistribution setRecordCount(@Property(value="recordCount") Number recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Number getConfidence() {
        return this.confidence;
    }

    public ScoreDistribution setConfidence(@Property(value="confidence") Number confidence) {
        this.confidence = confidence;
        return this;
    }

    public Number getProbability() {
        return this.probability;
    }

    public ScoreDistribution setProbability(@Property(value="probability") Number probability) {
        this.probability = probability;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ScoreDistribution addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

