/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.general_regression;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.general_regression.Predictor;
import org.dmg.pmml.general_regression.PredictorList;

@XmlRootElement(name="CovariateList", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "predictors"})
@JsonRootName(value="CovariateList")
@JsonPropertyOrder(value={"extensions", "predictors"})
public class CovariateList
extends PredictorList
implements HasExtensions<CovariateList> {
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="Predictor", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Predictor")
    private List<Predictor> predictors;
    private static final long serialVersionUID = 67371269L;

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public CovariateList addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public boolean hasPredictors() {
        return this.predictors != null && this.predictors.size() > 0;
    }

    @Override
    public List<Predictor> getPredictors() {
        if (this.predictors == null) {
            this.predictors = new ArrayList<Predictor>();
        }
        return this.predictors;
    }

    @Override
    public CovariateList addPredictors(Predictor ... predictors) {
        this.getPredictors().addAll(Arrays.asList(predictors));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasPredictors()) {
                status = PMMLObject.traverse(visitor, this.getPredictors());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

