/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.dmg.pmml.PMMLObject;

public class XPathUtil {
    private XPathUtil() {
    }

    public static String formatElement(Class<? extends PMMLObject> elementClazz) {
        return XPathUtil.getElementName(elementClazz);
    }

    public static String formatElementOrAttribute(Field field) {
        return XPathUtil.formatElementOrAttribute(field.getDeclaringClass(), field);
    }

    public static String formatElementOrAttribute(Class<? extends PMMLObject> elementClazz, Field field) {
        XmlElement element = field.getAnnotation(XmlElement.class);
        XmlAttribute attribute = field.getAnnotation(XmlAttribute.class);
        if (element != null) {
            Class childElementClazz = field.getType();
            if (List.class.isAssignableFrom(childElementClazz)) {
                ParameterizedType listType = (ParameterizedType)field.getGenericType();
                Type[] typeArguments = listType.getActualTypeArguments();
                if (typeArguments.length != 1) {
                    throw new IllegalArgumentException();
                }
                childElementClazz = (Class)typeArguments[0];
            }
            try {
                return XPathUtil.getElementName(elementClazz) + "/" + XPathUtil.getElementName(childElementClazz);
            }
            catch (IllegalArgumentException iae) {
                return XPathUtil.getElementName(elementClazz) + "/" + element.name();
            }
        }
        if (attribute != null) {
            return XPathUtil.getElementName(elementClazz) + "@" + attribute.name();
        }
        throw new IllegalArgumentException();
    }

    public static String formatAttribute(Field field, Object value) {
        return XPathUtil.formatAttribute(field.getDeclaringClass(), field, value);
    }

    public static String formatAttribute(Class<? extends PMMLObject> elementClazz, Field field, Object value) {
        XmlAttribute attribute = field.getAnnotation(XmlAttribute.class);
        if (attribute != null) {
            return XPathUtil.formatElementOrAttribute(elementClazz, field) + (value != null ? "=" + String.valueOf(value) : "");
        }
        throw new IllegalArgumentException();
    }

    private static String getElementName(Class<?> clazz) {
        while (clazz != null) {
            XmlRootElement rootElement = clazz.getAnnotation(XmlRootElement.class);
            if (rootElement != null) {
                return rootElement.name();
            }
            clazz = clazz.getSuperclass();
        }
        throw new IllegalArgumentException();
    }
}

