/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.BlockIndicator;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Lag;
import org.dmg.pmml.Model;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.association.Item;
import org.dmg.pmml.baseline.FieldValue;
import org.dmg.pmml.baseline.FieldValueCount;
import org.dmg.pmml.baseline.TestDistributions;
import org.dmg.pmml.bayesian_network.ContinuousNode;
import org.dmg.pmml.bayesian_network.DiscreteNode;
import org.dmg.pmml.bayesian_network.ParentValue;
import org.dmg.pmml.clustering.ClusteringField;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.general_regression.PPCell;
import org.dmg.pmml.general_regression.Predictor;
import org.dmg.pmml.mining.VariableWeight;
import org.dmg.pmml.naive_bayes.BayesInput;
import org.dmg.pmml.nearest_neighbor.KNNInput;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.regression.NumericPredictor;
import org.dmg.pmml.sequence.SetPredicate;
import org.jpmml.model.visitors.AbstractVisitor;
import org.jpmml.model.visitors.HasActiveFields;
import org.jpmml.model.visitors.Resettable;

public class ActiveFieldFinder
extends AbstractVisitor
implements Resettable {
    private Set<String> names = null;

    @Override
    public void reset() {
        if (this.names != null) {
            if (this.names.size() == 1) {
                this.names = null;
                return;
            }
            this.names.clear();
        }
    }

    @Override
    public VisitorAction visit(Aggregate aggregate) {
        this.process(aggregate.getField());
        this.process(aggregate.getGroupField());
        return super.visit(aggregate);
    }

    @Override
    public VisitorAction visit(BayesInput bayesInput) {
        this.process(bayesInput.getField());
        return super.visit(bayesInput);
    }

    @Override
    public VisitorAction visit(BlockIndicator blockIndicator) {
        this.process(blockIndicator.getField());
        return super.visit(blockIndicator);
    }

    @Override
    public VisitorAction visit(CategoricalPredictor categoricalPredictor) {
        this.process(categoricalPredictor.getField());
        return super.visit(categoricalPredictor);
    }

    @Override
    public VisitorAction visit(ClusteringField clusteringField) {
        this.process(clusteringField.getField());
        return super.visit(clusteringField);
    }

    @Override
    public VisitorAction visit(ContinuousNode continuousNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitorAction visit(DiscreteNode discreteNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitorAction visit(Discretize discretize) {
        this.process(discretize.getField());
        return super.visit(discretize);
    }

    @Override
    public VisitorAction visit(FieldColumnPair fieldColumnPair) {
        this.process(fieldColumnPair.getField());
        return super.visit(fieldColumnPair);
    }

    @Override
    public VisitorAction visit(FieldRef fieldRef) {
        this.process(fieldRef.getField());
        return super.visit(fieldRef);
    }

    @Override
    public VisitorAction visit(FieldValue fieldValue) {
        this.process(fieldValue.getField());
        return super.visit(fieldValue);
    }

    @Override
    public VisitorAction visit(FieldValueCount fieldValueCount) {
        this.process(fieldValueCount.getField());
        return super.visit(fieldValueCount);
    }

    @Override
    public VisitorAction visit(GeneralRegressionModel generalRegressionModel) {
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case COX_REGRESSION: {
                this.process(generalRegressionModel.getBaselineStrataVariable());
                this.process(generalRegressionModel.getEndTimeVariable());
                this.process(generalRegressionModel.getStartTimeVariable());
                this.process(generalRegressionModel.getStatusVariable());
                this.process(generalRegressionModel.getSubjectIDVariable());
            }
        }
        this.process(generalRegressionModel.getOffsetVariable());
        this.process(generalRegressionModel.getTrialsVariable());
        return super.visit(generalRegressionModel);
    }

    @Override
    public VisitorAction visit(Item item) {
        this.process(item.getField());
        return super.visit(item);
    }

    @Override
    public VisitorAction visit(KNNInput knnInput) {
        this.process(knnInput.getField());
        return super.visit(knnInput);
    }

    @Override
    public VisitorAction visit(Lag lag) {
        this.process(lag.getField());
        return super.visit(lag);
    }

    @Override
    public VisitorAction visit(Model model) {
        if (model instanceof HasActiveFields) {
            HasActiveFields hasActiveFields = (HasActiveFields)((Object)model);
            Set<String> names = hasActiveFields.getActiveFields();
            for (String name : names) {
                this.process(name);
            }
        }
        return super.visit(model);
    }

    @Override
    public VisitorAction visit(NormContinuous normContinuous) {
        this.process(normContinuous.getField());
        return super.visit(normContinuous);
    }

    @Override
    public VisitorAction visit(NormDiscrete normDiscrete) {
        this.process(normDiscrete.getField());
        return super.visit(normDiscrete);
    }

    @Override
    public VisitorAction visit(NumericPredictor numericPredictor) {
        this.process(numericPredictor.getField());
        return super.visit(numericPredictor);
    }

    @Override
    public VisitorAction visit(ParentValue parentValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitorAction visit(PPCell ppCell) {
        this.process(ppCell.getField());
        return super.visit(ppCell);
    }

    @Override
    public VisitorAction visit(Predictor predictor) {
        this.process(predictor.getField());
        return super.visit(predictor);
    }

    @Override
    public VisitorAction visit(SetPredicate setPredicate) {
        this.process(setPredicate.getField());
        return super.visit(setPredicate);
    }

    @Override
    public VisitorAction visit(SimplePredicate simplePredicate) {
        this.process(simplePredicate.getField());
        return super.visit(simplePredicate);
    }

    @Override
    public VisitorAction visit(SimpleSetPredicate simpleSetPredicate) {
        this.process(simpleSetPredicate.getField());
        return super.visit(simpleSetPredicate);
    }

    @Override
    public VisitorAction visit(TestDistributions testDistributions) {
        this.process(testDistributions.getField());
        this.process(testDistributions.getWeightField());
        return super.visit(testDistributions);
    }

    @Override
    public VisitorAction visit(TextIndex textIndex) {
        this.process(textIndex.getTextField());
        return super.visit(textIndex);
    }

    @Override
    public VisitorAction visit(VariableWeight variableWeight) {
        this.process(variableWeight.getField());
        return super.visit(variableWeight);
    }

    public Set<String> getFieldNames() {
        if (this.names == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.names);
    }

    private void process(String name) {
        if (name == null) {
            return;
        }
        if (this.names != null) {
            if (this.names.size() == 1) {
                if (this.names.contains(name)) {
                    return;
                }
                this.names = new HashSet<String>(this.names);
            }
            this.names.add(name);
        } else {
            this.names = Collections.singleton(name);
        }
    }

    public static Set<String> getFieldNames(PMMLObject ... objects) {
        return ActiveFieldFinder.getFieldNames(new ActiveFieldFinder(), objects);
    }

    public static Set<String> getFieldNames(ActiveFieldFinder activeFieldFinder, PMMLObject ... objects) {
        for (PMMLObject object : objects) {
            activeFieldFinder.applyTo(object);
        }
        return activeFieldFinder.getFieldNames();
    }
}

